<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSiparis ArrayType
 * @subpackage Arrays
 */
class ArrayOfSiparis extends AbstractStructArrayBase
{
    /**
     * The Siparis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Siparis[]
     */
    public $Siparis;
    /**
     * Constructor method for ArrayOfSiparis
     * @uses ArrayOfSiparis::setSiparis()
     * @param \StructType\Siparis[] $siparis
     */
    public function __construct(array $siparis = array())
    {
        $this
            ->setSiparis($siparis);
    }
    /**
     * Get Siparis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Siparis[]|null
     */
    public function getSiparis()
    {
        return isset($this->Siparis) ? $this->Siparis : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSiparis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSiparis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSiparisForArrayConstraintsFromSetSiparis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSiparisSiparisItem) {
            // validation for constraint: itemType
            if (!$arrayOfSiparisSiparisItem instanceof \StructType\Siparis) {
                $invalidValues[] = is_object($arrayOfSiparisSiparisItem) ? get_class($arrayOfSiparisSiparisItem) : sprintf('%s(%s)', gettype($arrayOfSiparisSiparisItem), var_export($arrayOfSiparisSiparisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Siparis property can only contain items of type \StructType\Siparis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Siparis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Siparis[] $siparis
     * @return \ArrayType\ArrayOfSiparis
     */
    public function setSiparis(array $siparis = array())
    {
        // validation for constraint: array
        if ('' !== ($siparisArrayErrorMessage = self::validateSiparisForArrayConstraintsFromSetSiparis($siparis))) {
            throw new \InvalidArgumentException($siparisArrayErrorMessage, __LINE__);
        }
        if (is_null($siparis) || (is_array($siparis) && empty($siparis))) {
            unset($this->Siparis);
        } else {
            $this->Siparis = $siparis;
        }
        return $this;
    }
    /**
     * Add item to Siparis value
     * @throws \InvalidArgumentException
     * @param \StructType\Siparis $item
     * @return \ArrayType\ArrayOfSiparis
     */
    public function addToSiparis(\StructType\Siparis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Siparis) {
            throw new \InvalidArgumentException(sprintf('The Siparis property can only contain items of type \StructType\Siparis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Siparis[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Siparis|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Siparis|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Siparis|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Siparis|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Siparis|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Siparis
     */
    public function getAttributeName()
    {
        return 'Siparis';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSiparis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
