<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.migros.com.tr:8083/soap/b2b/siparis?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.migros.com.tr:8083/soap/b2b/siparis?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetSiparisler operation/method
 */
if ($get->GetSiparisler(new \StructType\GetSiparisler()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetYeniSiparisler operation/method
 */
if ($get->GetYeniSiparisler(new \StructType\GetYeniSiparisler()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetYeniSiparislerByTarih operation/method
 */
if ($get->GetYeniSiparislerByTarih(new \StructType\GetYeniSiparislerByTarih()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOnaylanmisSiparisler operation/method
 */
if ($get->GetOnaylanmisSiparisler(new \StructType\GetOnaylanmisSiparisler()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Kaydet ServiceType
 */
$kaydet = new \ServiceType\Kaydet($options);
/**
 * Sample call for Kaydet operation/method
 */
if ($kaydet->Kaydet(new \StructType\Kaydet()) !== false) {
    print_r($kaydet->getResult());
} else {
    print_r($kaydet->getLastError());
}
/**
 * Samples for Onay ServiceType
 */
$onay = new \ServiceType\Onay($options);
/**
 * Sample call for Onay operation/method
 */
if ($onay->Onay(new \StructType\Onay()) !== false) {
    print_r($onay->getResult());
} else {
    print_r($onay->getLastError());
}
