<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Siparis StructType
 * @subpackage Structs
 */
class Siparis extends AbstractStructBase
{
    /**
     * The TeslimTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TeslimTarihi;
    /**
     * The UrunSayisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UrunSayisi;
    /**
     * The ToplamNetTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToplamNetTutar;
    /**
     * The ToplamNetOnaylananTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToplamNetOnaylananTutar;
    /**
     * The InsertDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InsertDateTime;
    /**
     * The SiparisId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiparisId;
    /**
     * The SiparisNumarasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiparisNumarasi;
    /**
     * The Satici
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Satici;
    /**
     * The SaticiId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SaticiId;
    /**
     * The SaticiTeslimNoktasiId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SaticiTeslimNoktasiId;
    /**
     * The Alici
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alici;
    /**
     * The TeslimNoktasiId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TeslimNoktasiId;
    /**
     * The TeslimNoktasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TeslimNoktasi;
    /**
     * The TeslimNoktasiAdres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TeslimNoktasiAdres;
    /**
     * The Telefon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telefon;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The DurumId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DurumId;
    /**
     * The DurumAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DurumAdi;
    /**
     * The SonGuncelleyenUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SonGuncelleyenUserId;
    /**
     * The SonGuncelleyenUserAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SonGuncelleyenUserAdi;
    /**
     * The AliciyaMesaj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AliciyaMesaj;
    /**
     * The SaticiyaMesaj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SaticiyaMesaj;
    /**
     * The Urun
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUrun
     */
    public $Urun;
    /**
     * The HataMesaj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HataMesaj;
    /**
     * Constructor method for Siparis
     * @uses Siparis::setTeslimTarihi()
     * @uses Siparis::setUrunSayisi()
     * @uses Siparis::setToplamNetTutar()
     * @uses Siparis::setToplamNetOnaylananTutar()
     * @uses Siparis::setInsertDateTime()
     * @uses Siparis::setSiparisId()
     * @uses Siparis::setSiparisNumarasi()
     * @uses Siparis::setSatici()
     * @uses Siparis::setSaticiId()
     * @uses Siparis::setSaticiTeslimNoktasiId()
     * @uses Siparis::setAlici()
     * @uses Siparis::setTeslimNoktasiId()
     * @uses Siparis::setTeslimNoktasi()
     * @uses Siparis::setTeslimNoktasiAdres()
     * @uses Siparis::setTelefon()
     * @uses Siparis::setFax()
     * @uses Siparis::setDurumId()
     * @uses Siparis::setDurumAdi()
     * @uses Siparis::setSonGuncelleyenUserId()
     * @uses Siparis::setSonGuncelleyenUserAdi()
     * @uses Siparis::setAliciyaMesaj()
     * @uses Siparis::setSaticiyaMesaj()
     * @uses Siparis::setUrun()
     * @uses Siparis::setHataMesaj()
     * @param string $teslimTarihi
     * @param int $urunSayisi
     * @param float $toplamNetTutar
     * @param float $toplamNetOnaylananTutar
     * @param string $insertDateTime
     * @param string $siparisId
     * @param string $siparisNumarasi
     * @param string $satici
     * @param string $saticiId
     * @param string $saticiTeslimNoktasiId
     * @param string $alici
     * @param string $teslimNoktasiId
     * @param string $teslimNoktasi
     * @param string $teslimNoktasiAdres
     * @param string $telefon
     * @param string $fax
     * @param string $durumId
     * @param string $durumAdi
     * @param string $sonGuncelleyenUserId
     * @param string $sonGuncelleyenUserAdi
     * @param string $aliciyaMesaj
     * @param string $saticiyaMesaj
     * @param \ArrayType\ArrayOfUrun $urun
     * @param string $hataMesaj
     */
    public function __construct($teslimTarihi = null, $urunSayisi = null, $toplamNetTutar = null, $toplamNetOnaylananTutar = null, $insertDateTime = null, $siparisId = null, $siparisNumarasi = null, $satici = null, $saticiId = null, $saticiTeslimNoktasiId = null, $alici = null, $teslimNoktasiId = null, $teslimNoktasi = null, $teslimNoktasiAdres = null, $telefon = null, $fax = null, $durumId = null, $durumAdi = null, $sonGuncelleyenUserId = null, $sonGuncelleyenUserAdi = null, $aliciyaMesaj = null, $saticiyaMesaj = null, \ArrayType\ArrayOfUrun $urun = null, $hataMesaj = null)
    {
        $this
            ->setTeslimTarihi($teslimTarihi)
            ->setUrunSayisi($urunSayisi)
            ->setToplamNetTutar($toplamNetTutar)
            ->setToplamNetOnaylananTutar($toplamNetOnaylananTutar)
            ->setInsertDateTime($insertDateTime)
            ->setSiparisId($siparisId)
            ->setSiparisNumarasi($siparisNumarasi)
            ->setSatici($satici)
            ->setSaticiId($saticiId)
            ->setSaticiTeslimNoktasiId($saticiTeslimNoktasiId)
            ->setAlici($alici)
            ->setTeslimNoktasiId($teslimNoktasiId)
            ->setTeslimNoktasi($teslimNoktasi)
            ->setTeslimNoktasiAdres($teslimNoktasiAdres)
            ->setTelefon($telefon)
            ->setFax($fax)
            ->setDurumId($durumId)
            ->setDurumAdi($durumAdi)
            ->setSonGuncelleyenUserId($sonGuncelleyenUserId)
            ->setSonGuncelleyenUserAdi($sonGuncelleyenUserAdi)
            ->setAliciyaMesaj($aliciyaMesaj)
            ->setSaticiyaMesaj($saticiyaMesaj)
            ->setUrun($urun)
            ->setHataMesaj($hataMesaj);
    }
    /**
     * Get TeslimTarihi value
     * @return string
     */
    public function getTeslimTarihi()
    {
        return $this->TeslimTarihi;
    }
    /**
     * Set TeslimTarihi value
     * @param string $teslimTarihi
     * @return \StructType\Siparis
     */
    public function setTeslimTarihi($teslimTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($teslimTarihi) && !is_string($teslimTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teslimTarihi, true), gettype($teslimTarihi)), __LINE__);
        }
        $this->TeslimTarihi = $teslimTarihi;
        return $this;
    }
    /**
     * Get UrunSayisi value
     * @return int
     */
    public function getUrunSayisi()
    {
        return $this->UrunSayisi;
    }
    /**
     * Set UrunSayisi value
     * @param int $urunSayisi
     * @return \StructType\Siparis
     */
    public function setUrunSayisi($urunSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($urunSayisi) && !(is_int($urunSayisi) || ctype_digit($urunSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunSayisi, true), gettype($urunSayisi)), __LINE__);
        }
        $this->UrunSayisi = $urunSayisi;
        return $this;
    }
    /**
     * Get ToplamNetTutar value
     * @return float
     */
    public function getToplamNetTutar()
    {
        return $this->ToplamNetTutar;
    }
    /**
     * Set ToplamNetTutar value
     * @param float $toplamNetTutar
     * @return \StructType\Siparis
     */
    public function setToplamNetTutar($toplamNetTutar = null)
    {
        // validation for constraint: float
        if (!is_null($toplamNetTutar) && !(is_float($toplamNetTutar) || is_numeric($toplamNetTutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamNetTutar, true), gettype($toplamNetTutar)), __LINE__);
        }
        $this->ToplamNetTutar = $toplamNetTutar;
        return $this;
    }
    /**
     * Get ToplamNetOnaylananTutar value
     * @return float
     */
    public function getToplamNetOnaylananTutar()
    {
        return $this->ToplamNetOnaylananTutar;
    }
    /**
     * Set ToplamNetOnaylananTutar value
     * @param float $toplamNetOnaylananTutar
     * @return \StructType\Siparis
     */
    public function setToplamNetOnaylananTutar($toplamNetOnaylananTutar = null)
    {
        // validation for constraint: float
        if (!is_null($toplamNetOnaylananTutar) && !(is_float($toplamNetOnaylananTutar) || is_numeric($toplamNetOnaylananTutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamNetOnaylananTutar, true), gettype($toplamNetOnaylananTutar)), __LINE__);
        }
        $this->ToplamNetOnaylananTutar = $toplamNetOnaylananTutar;
        return $this;
    }
    /**
     * Get InsertDateTime value
     * @return string
     */
    public function getInsertDateTime()
    {
        return $this->InsertDateTime;
    }
    /**
     * Set InsertDateTime value
     * @param string $insertDateTime
     * @return \StructType\Siparis
     */
    public function setInsertDateTime($insertDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($insertDateTime) && !is_string($insertDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertDateTime, true), gettype($insertDateTime)), __LINE__);
        }
        $this->InsertDateTime = $insertDateTime;
        return $this;
    }
    /**
     * Get SiparisId value
     * @return string|null
     */
    public function getSiparisId()
    {
        return $this->SiparisId;
    }
    /**
     * Set SiparisId value
     * @param string $siparisId
     * @return \StructType\Siparis
     */
    public function setSiparisId($siparisId = null)
    {
        // validation for constraint: string
        if (!is_null($siparisId) && !is_string($siparisId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisId, true), gettype($siparisId)), __LINE__);
        }
        $this->SiparisId = $siparisId;
        return $this;
    }
    /**
     * Get SiparisNumarasi value
     * @return string|null
     */
    public function getSiparisNumarasi()
    {
        return $this->SiparisNumarasi;
    }
    /**
     * Set SiparisNumarasi value
     * @param string $siparisNumarasi
     * @return \StructType\Siparis
     */
    public function setSiparisNumarasi($siparisNumarasi = null)
    {
        // validation for constraint: string
        if (!is_null($siparisNumarasi) && !is_string($siparisNumarasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisNumarasi, true), gettype($siparisNumarasi)), __LINE__);
        }
        $this->SiparisNumarasi = $siparisNumarasi;
        return $this;
    }
    /**
     * Get Satici value
     * @return string|null
     */
    public function getSatici()
    {
        return $this->Satici;
    }
    /**
     * Set Satici value
     * @param string $satici
     * @return \StructType\Siparis
     */
    public function setSatici($satici = null)
    {
        // validation for constraint: string
        if (!is_null($satici) && !is_string($satici)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($satici, true), gettype($satici)), __LINE__);
        }
        $this->Satici = $satici;
        return $this;
    }
    /**
     * Get SaticiId value
     * @return string|null
     */
    public function getSaticiId()
    {
        return $this->SaticiId;
    }
    /**
     * Set SaticiId value
     * @param string $saticiId
     * @return \StructType\Siparis
     */
    public function setSaticiId($saticiId = null)
    {
        // validation for constraint: string
        if (!is_null($saticiId) && !is_string($saticiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saticiId, true), gettype($saticiId)), __LINE__);
        }
        $this->SaticiId = $saticiId;
        return $this;
    }
    /**
     * Get SaticiTeslimNoktasiId value
     * @return string|null
     */
    public function getSaticiTeslimNoktasiId()
    {
        return $this->SaticiTeslimNoktasiId;
    }
    /**
     * Set SaticiTeslimNoktasiId value
     * @param string $saticiTeslimNoktasiId
     * @return \StructType\Siparis
     */
    public function setSaticiTeslimNoktasiId($saticiTeslimNoktasiId = null)
    {
        // validation for constraint: string
        if (!is_null($saticiTeslimNoktasiId) && !is_string($saticiTeslimNoktasiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saticiTeslimNoktasiId, true), gettype($saticiTeslimNoktasiId)), __LINE__);
        }
        $this->SaticiTeslimNoktasiId = $saticiTeslimNoktasiId;
        return $this;
    }
    /**
     * Get Alici value
     * @return string|null
     */
    public function getAlici()
    {
        return $this->Alici;
    }
    /**
     * Set Alici value
     * @param string $alici
     * @return \StructType\Siparis
     */
    public function setAlici($alici = null)
    {
        // validation for constraint: string
        if (!is_null($alici) && !is_string($alici)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alici, true), gettype($alici)), __LINE__);
        }
        $this->Alici = $alici;
        return $this;
    }
    /**
     * Get TeslimNoktasiId value
     * @return string|null
     */
    public function getTeslimNoktasiId()
    {
        return $this->TeslimNoktasiId;
    }
    /**
     * Set TeslimNoktasiId value
     * @param string $teslimNoktasiId
     * @return \StructType\Siparis
     */
    public function setTeslimNoktasiId($teslimNoktasiId = null)
    {
        // validation for constraint: string
        if (!is_null($teslimNoktasiId) && !is_string($teslimNoktasiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teslimNoktasiId, true), gettype($teslimNoktasiId)), __LINE__);
        }
        $this->TeslimNoktasiId = $teslimNoktasiId;
        return $this;
    }
    /**
     * Get TeslimNoktasi value
     * @return string|null
     */
    public function getTeslimNoktasi()
    {
        return $this->TeslimNoktasi;
    }
    /**
     * Set TeslimNoktasi value
     * @param string $teslimNoktasi
     * @return \StructType\Siparis
     */
    public function setTeslimNoktasi($teslimNoktasi = null)
    {
        // validation for constraint: string
        if (!is_null($teslimNoktasi) && !is_string($teslimNoktasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teslimNoktasi, true), gettype($teslimNoktasi)), __LINE__);
        }
        $this->TeslimNoktasi = $teslimNoktasi;
        return $this;
    }
    /**
     * Get TeslimNoktasiAdres value
     * @return string|null
     */
    public function getTeslimNoktasiAdres()
    {
        return $this->TeslimNoktasiAdres;
    }
    /**
     * Set TeslimNoktasiAdres value
     * @param string $teslimNoktasiAdres
     * @return \StructType\Siparis
     */
    public function setTeslimNoktasiAdres($teslimNoktasiAdres = null)
    {
        // validation for constraint: string
        if (!is_null($teslimNoktasiAdres) && !is_string($teslimNoktasiAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teslimNoktasiAdres, true), gettype($teslimNoktasiAdres)), __LINE__);
        }
        $this->TeslimNoktasiAdres = $teslimNoktasiAdres;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @param string $telefon
     * @return \StructType\Siparis
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\Siparis
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get DurumId value
     * @return string|null
     */
    public function getDurumId()
    {
        return $this->DurumId;
    }
    /**
     * Set DurumId value
     * @param string $durumId
     * @return \StructType\Siparis
     */
    public function setDurumId($durumId = null)
    {
        // validation for constraint: string
        if (!is_null($durumId) && !is_string($durumId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durumId, true), gettype($durumId)), __LINE__);
        }
        $this->DurumId = $durumId;
        return $this;
    }
    /**
     * Get DurumAdi value
     * @return string|null
     */
    public function getDurumAdi()
    {
        return $this->DurumAdi;
    }
    /**
     * Set DurumAdi value
     * @param string $durumAdi
     * @return \StructType\Siparis
     */
    public function setDurumAdi($durumAdi = null)
    {
        // validation for constraint: string
        if (!is_null($durumAdi) && !is_string($durumAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durumAdi, true), gettype($durumAdi)), __LINE__);
        }
        $this->DurumAdi = $durumAdi;
        return $this;
    }
    /**
     * Get SonGuncelleyenUserId value
     * @return string|null
     */
    public function getSonGuncelleyenUserId()
    {
        return $this->SonGuncelleyenUserId;
    }
    /**
     * Set SonGuncelleyenUserId value
     * @param string $sonGuncelleyenUserId
     * @return \StructType\Siparis
     */
    public function setSonGuncelleyenUserId($sonGuncelleyenUserId = null)
    {
        // validation for constraint: string
        if (!is_null($sonGuncelleyenUserId) && !is_string($sonGuncelleyenUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonGuncelleyenUserId, true), gettype($sonGuncelleyenUserId)), __LINE__);
        }
        $this->SonGuncelleyenUserId = $sonGuncelleyenUserId;
        return $this;
    }
    /**
     * Get SonGuncelleyenUserAdi value
     * @return string|null
     */
    public function getSonGuncelleyenUserAdi()
    {
        return $this->SonGuncelleyenUserAdi;
    }
    /**
     * Set SonGuncelleyenUserAdi value
     * @param string $sonGuncelleyenUserAdi
     * @return \StructType\Siparis
     */
    public function setSonGuncelleyenUserAdi($sonGuncelleyenUserAdi = null)
    {
        // validation for constraint: string
        if (!is_null($sonGuncelleyenUserAdi) && !is_string($sonGuncelleyenUserAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonGuncelleyenUserAdi, true), gettype($sonGuncelleyenUserAdi)), __LINE__);
        }
        $this->SonGuncelleyenUserAdi = $sonGuncelleyenUserAdi;
        return $this;
    }
    /**
     * Get AliciyaMesaj value
     * @return string|null
     */
    public function getAliciyaMesaj()
    {
        return $this->AliciyaMesaj;
    }
    /**
     * Set AliciyaMesaj value
     * @param string $aliciyaMesaj
     * @return \StructType\Siparis
     */
    public function setAliciyaMesaj($aliciyaMesaj = null)
    {
        // validation for constraint: string
        if (!is_null($aliciyaMesaj) && !is_string($aliciyaMesaj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliciyaMesaj, true), gettype($aliciyaMesaj)), __LINE__);
        }
        $this->AliciyaMesaj = $aliciyaMesaj;
        return $this;
    }
    /**
     * Get SaticiyaMesaj value
     * @return string|null
     */
    public function getSaticiyaMesaj()
    {
        return $this->SaticiyaMesaj;
    }
    /**
     * Set SaticiyaMesaj value
     * @param string $saticiyaMesaj
     * @return \StructType\Siparis
     */
    public function setSaticiyaMesaj($saticiyaMesaj = null)
    {
        // validation for constraint: string
        if (!is_null($saticiyaMesaj) && !is_string($saticiyaMesaj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saticiyaMesaj, true), gettype($saticiyaMesaj)), __LINE__);
        }
        $this->SaticiyaMesaj = $saticiyaMesaj;
        return $this;
    }
    /**
     * Get Urun value
     * @return \ArrayType\ArrayOfUrun|null
     */
    public function getUrun()
    {
        return $this->Urun;
    }
    /**
     * Set Urun value
     * @param \ArrayType\ArrayOfUrun $urun
     * @return \StructType\Siparis
     */
    public function setUrun(\ArrayType\ArrayOfUrun $urun = null)
    {
        $this->Urun = $urun;
        return $this;
    }
    /**
     * Get HataMesaj value
     * @return string|null
     */
    public function getHataMesaj()
    {
        return $this->HataMesaj;
    }
    /**
     * Set HataMesaj value
     * @param string $hataMesaj
     * @return \StructType\Siparis
     */
    public function setHataMesaj($hataMesaj = null)
    {
        // validation for constraint: string
        if (!is_null($hataMesaj) && !is_string($hataMesaj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hataMesaj, true), gettype($hataMesaj)), __LINE__);
        }
        $this->HataMesaj = $hataMesaj;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Siparis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
