<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZKwfGetRequestsByUserResponse StructType
 * @subpackage Structs
 */
class ZKwfGetRequestsByUserResponse extends AbstractStructBase
{
    /**
     * The EsitoCod
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * @var string
     */
    public $EsitoCod;
    /**
     * The EsitoTxt
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * @var string
     */
    public $EsitoTxt;
    /**
     * The ItRequestList
     * @var \StructType\TableOfZkwfRequestLst
     */
    public $ItRequestList;
    /**
     * Constructor method for ZKwfGetRequestsByUserResponse
     * @uses ZKwfGetRequestsByUserResponse::setEsitoCod()
     * @uses ZKwfGetRequestsByUserResponse::setEsitoTxt()
     * @uses ZKwfGetRequestsByUserResponse::setItRequestList()
     * @param string $esitoCod
     * @param string $esitoTxt
     * @param \StructType\TableOfZkwfRequestLst $itRequestList
     */
    public function __construct($esitoCod = null, $esitoTxt = null, \StructType\TableOfZkwfRequestLst $itRequestList = null)
    {
        $this
            ->setEsitoCod($esitoCod)
            ->setEsitoTxt($esitoTxt)
            ->setItRequestList($itRequestList);
    }
    /**
     * Get EsitoCod value
     * @return string|null
     */
    public function getEsitoCod()
    {
        return $this->EsitoCod;
    }
    /**
     * Set EsitoCod value
     * @param string $esitoCod
     * @return \StructType\ZKwfGetRequestsByUserResponse
     */
    public function setEsitoCod($esitoCod = null)
    {
        // validation for constraint: string
        if (!is_null($esitoCod) && !is_string($esitoCod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esitoCod, true), gettype($esitoCod)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($esitoCod) && mb_strlen($esitoCod) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($esitoCod)), __LINE__);
        }
        $this->EsitoCod = $esitoCod;
        return $this;
    }
    /**
     * Get EsitoTxt value
     * @return string|null
     */
    public function getEsitoTxt()
    {
        return $this->EsitoTxt;
    }
    /**
     * Set EsitoTxt value
     * @param string $esitoTxt
     * @return \StructType\ZKwfGetRequestsByUserResponse
     */
    public function setEsitoTxt($esitoTxt = null)
    {
        // validation for constraint: string
        if (!is_null($esitoTxt) && !is_string($esitoTxt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esitoTxt, true), gettype($esitoTxt)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($esitoTxt) && mb_strlen($esitoTxt) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($esitoTxt)), __LINE__);
        }
        $this->EsitoTxt = $esitoTxt;
        return $this;
    }
    /**
     * Get ItRequestList value
     * @return \StructType\TableOfZkwfRequestLst|null
     */
    public function getItRequestList()
    {
        return $this->ItRequestList;
    }
    /**
     * Set ItRequestList value
     * @param \StructType\TableOfZkwfRequestLst $itRequestList
     * @return \StructType\ZKwfGetRequestsByUserResponse
     */
    public function setItRequestList(\StructType\TableOfZkwfRequestLst $itRequestList = null)
    {
        $this->ItRequestList = $itRequestList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZKwfGetRequestsByUserResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
