<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZKwfGetRequestsByUser StructType
 * @subpackage Structs
 */
class ZKwfGetRequestsByUser extends AbstractStructBase
{
    /**
     * The ItRequestList
     * @var \StructType\TableOfZkwfRequestLst
     */
    public $ItRequestList;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 241
     * @var string
     */
    public $User;
    /**
     * Constructor method for ZKwfGetRequestsByUser
     * @uses ZKwfGetRequestsByUser::setItRequestList()
     * @uses ZKwfGetRequestsByUser::setUser()
     * @param \StructType\TableOfZkwfRequestLst $itRequestList
     * @param string $user
     */
    public function __construct(\StructType\TableOfZkwfRequestLst $itRequestList = null, $user = null)
    {
        $this
            ->setItRequestList($itRequestList)
            ->setUser($user);
    }
    /**
     * Get ItRequestList value
     * @return \StructType\TableOfZkwfRequestLst|null
     */
    public function getItRequestList()
    {
        return $this->ItRequestList;
    }
    /**
     * Set ItRequestList value
     * @param \StructType\TableOfZkwfRequestLst $itRequestList
     * @return \StructType\ZKwfGetRequestsByUser
     */
    public function setItRequestList(\StructType\TableOfZkwfRequestLst $itRequestList = null)
    {
        $this->ItRequestList = $itRequestList;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\ZKwfGetRequestsByUser
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: maxLength(241)
        if (!is_null($user) && mb_strlen($user) > 241) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 241', mb_strlen($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZKwfGetRequestsByUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
