<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ZK ServiceType
 * @subpackage Services
 */
class ZK extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZKwfGetRequestsByUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZKwfGetRequestsByUser $parameters
     * @return \StructType\ZKwfGetRequestsByUserResponse|bool
     */
    public function ZKwfGetRequestsByUser(\StructType\ZKwfGetRequestsByUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZKwfGetRequestsByUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZKwfGetRequestsByUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
