<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeatherInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of WeatherInfo elements. This may be used to provide information for multiple time periods.
 * @subpackage Structs
 */
class WeatherInfos extends AbstractStructBase
{
    /**
     * The WeatherInfo
     * Meta information extracted from the WSDL
     * - documentation: Provides detailed information regarding weather.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $WeatherInfo;
    /**
     * Constructor method for WeatherInfos
     * @uses WeatherInfos::setWeatherInfo()
     * @param mixed[] $weatherInfo
     */
    public function __construct(array $weatherInfo = array())
    {
        $this
            ->setWeatherInfo($weatherInfo);
    }
    /**
     * Get WeatherInfo value
     * @return mixed[]|null
     */
    public function getWeatherInfo()
    {
        return $this->WeatherInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setWeatherInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeatherInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeatherInfoForArrayConstraintsFromSetWeatherInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $weatherInfosWeatherInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($weatherInfosWeatherInfoItem) ? get_class($weatherInfosWeatherInfoItem) : sprintf('%s(%s)', gettype($weatherInfosWeatherInfoItem), var_export($weatherInfosWeatherInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WeatherInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WeatherInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $weatherInfo
     * @return \StructType\WeatherInfos
     */
    public function setWeatherInfo(array $weatherInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($weatherInfoArrayErrorMessage = self::validateWeatherInfoForArrayConstraintsFromSetWeatherInfo($weatherInfo))) {
            throw new \InvalidArgumentException($weatherInfoArrayErrorMessage, __LINE__);
        }
        $this->WeatherInfo = $weatherInfo;
        return $this;
    }
    /**
     * Add item to WeatherInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\WeatherInfos
     */
    public function addToWeatherInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The WeatherInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WeatherInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WeatherInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
