<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Water StructType
 * Meta information extracted from the WSDL
 * - documentation: Water usage information.
 * @subpackage Structs
 */
class Water extends AbstractStructBase
{
    /**
     * The WaterUOM
     * Meta information extracted from the WSDL
     * - documentation: Example: Gallon(s) | Water unit of measure.
     * - minOccurs: 0
     * @var mixed
     */
    public $WaterUOM;
    /**
     * The ProgramDescription
     * Meta information extracted from the WSDL
     * - documentation: Water conservation program description.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ProgramDescription;
    /**
     * The GrayWaterInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property recycles gray-water through watering of plants and landscaping. | Example: true | Grey water recycling indicator.
     * - use: optional
     * @var bool
     */
    public $GrayWaterInd;
    /**
     * The WaterProgramInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property has an active water conservation program in place, that may include low flow shower heads and toilets. | Example: true | Active water conservation program indicator.
     * - use: optional
     * @var bool
     */
    public $WaterProgramInd;
    /**
     * The PerRoomNightUsage
     * Meta information extracted from the WSDL
     * - documentation: Implementer: The associated unit of measure is specified in the WaterUOM element. | Example: 60 | Water usage per room per night.
     * - use: optional
     * @var int
     */
    public $PerRoomNightUsage;
    /**
     * The PerRoomDayUsage
     * Meta information extracted from the WSDL
     * - documentation: Implementer: The associated water unit of measure is specified in the WaterUOM element. | Example: 40 | Water usage per room per day.
     * - use: optional
     * @var int
     */
    public $PerRoomDayUsage;
    /**
     * The WasteDiversionPercentage
     * Meta information extracted from the WSDL
     * - documentation: Defines the waste diversion rate.
     * - use: optional
     * @var float
     */
    public $WasteDiversionPercentage;
    /**
     * Constructor method for Water
     * @uses Water::setWaterUOM()
     * @uses Water::setProgramDescription()
     * @uses Water::setGrayWaterInd()
     * @uses Water::setWaterProgramInd()
     * @uses Water::setPerRoomNightUsage()
     * @uses Water::setPerRoomDayUsage()
     * @uses Water::setWasteDiversionPercentage()
     * @param mixed $waterUOM
     * @param mixed[] $programDescription
     * @param bool $grayWaterInd
     * @param bool $waterProgramInd
     * @param int $perRoomNightUsage
     * @param int $perRoomDayUsage
     * @param float $wasteDiversionPercentage
     */
    public function __construct($waterUOM = null, array $programDescription = array(), $grayWaterInd = null, $waterProgramInd = null, $perRoomNightUsage = null, $perRoomDayUsage = null, $wasteDiversionPercentage = null)
    {
        $this
            ->setWaterUOM($waterUOM)
            ->setProgramDescription($programDescription)
            ->setGrayWaterInd($grayWaterInd)
            ->setWaterProgramInd($waterProgramInd)
            ->setPerRoomNightUsage($perRoomNightUsage)
            ->setPerRoomDayUsage($perRoomDayUsage)
            ->setWasteDiversionPercentage($wasteDiversionPercentage);
    }
    /**
     * Get WaterUOM value
     * @return mixed|null
     */
    public function getWaterUOM()
    {
        return $this->WaterUOM;
    }
    /**
     * Set WaterUOM value
     * @param mixed $waterUOM
     * @return \StructType\Water
     */
    public function setWaterUOM($waterUOM = null)
    {
        $this->WaterUOM = $waterUOM;
        return $this;
    }
    /**
     * Get ProgramDescription value
     * @return mixed[]|null
     */
    public function getProgramDescription()
    {
        return $this->ProgramDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setProgramDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgramDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgramDescriptionForArrayConstraintsFromSetProgramDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $waterProgramDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($waterProgramDescriptionItem) ? get_class($waterProgramDescriptionItem) : sprintf('%s(%s)', gettype($waterProgramDescriptionItem), var_export($waterProgramDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgramDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgramDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $programDescription
     * @return \StructType\Water
     */
    public function setProgramDescription(array $programDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($programDescriptionArrayErrorMessage = self::validateProgramDescriptionForArrayConstraintsFromSetProgramDescription($programDescription))) {
            throw new \InvalidArgumentException($programDescriptionArrayErrorMessage, __LINE__);
        }
        $this->ProgramDescription = $programDescription;
        return $this;
    }
    /**
     * Add item to ProgramDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Water
     */
    public function addToProgramDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ProgramDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProgramDescription[] = $item;
        return $this;
    }
    /**
     * Get GrayWaterInd value
     * @return bool|null
     */
    public function getGrayWaterInd()
    {
        return $this->GrayWaterInd;
    }
    /**
     * Set GrayWaterInd value
     * @param bool $grayWaterInd
     * @return \StructType\Water
     */
    public function setGrayWaterInd($grayWaterInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($grayWaterInd) && !is_bool($grayWaterInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($grayWaterInd, true), gettype($grayWaterInd)), __LINE__);
        }
        $this->GrayWaterInd = $grayWaterInd;
        return $this;
    }
    /**
     * Get WaterProgramInd value
     * @return bool|null
     */
    public function getWaterProgramInd()
    {
        return $this->WaterProgramInd;
    }
    /**
     * Set WaterProgramInd value
     * @param bool $waterProgramInd
     * @return \StructType\Water
     */
    public function setWaterProgramInd($waterProgramInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($waterProgramInd) && !is_bool($waterProgramInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waterProgramInd, true), gettype($waterProgramInd)), __LINE__);
        }
        $this->WaterProgramInd = $waterProgramInd;
        return $this;
    }
    /**
     * Get PerRoomNightUsage value
     * @return int|null
     */
    public function getPerRoomNightUsage()
    {
        return $this->PerRoomNightUsage;
    }
    /**
     * Set PerRoomNightUsage value
     * @param int $perRoomNightUsage
     * @return \StructType\Water
     */
    public function setPerRoomNightUsage($perRoomNightUsage = null)
    {
        // validation for constraint: int
        if (!is_null($perRoomNightUsage) && !(is_int($perRoomNightUsage) || ctype_digit($perRoomNightUsage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($perRoomNightUsage, true), gettype($perRoomNightUsage)), __LINE__);
        }
        $this->PerRoomNightUsage = $perRoomNightUsage;
        return $this;
    }
    /**
     * Get PerRoomDayUsage value
     * @return int|null
     */
    public function getPerRoomDayUsage()
    {
        return $this->PerRoomDayUsage;
    }
    /**
     * Set PerRoomDayUsage value
     * @param int $perRoomDayUsage
     * @return \StructType\Water
     */
    public function setPerRoomDayUsage($perRoomDayUsage = null)
    {
        // validation for constraint: int
        if (!is_null($perRoomDayUsage) && !(is_int($perRoomDayUsage) || ctype_digit($perRoomDayUsage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($perRoomDayUsage, true), gettype($perRoomDayUsage)), __LINE__);
        }
        $this->PerRoomDayUsage = $perRoomDayUsage;
        return $this;
    }
    /**
     * Get WasteDiversionPercentage value
     * @return float|null
     */
    public function getWasteDiversionPercentage()
    {
        return $this->WasteDiversionPercentage;
    }
    /**
     * Set WasteDiversionPercentage value
     * @param float $wasteDiversionPercentage
     * @return \StructType\Water
     */
    public function setWasteDiversionPercentage($wasteDiversionPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($wasteDiversionPercentage) && !(is_float($wasteDiversionPercentage) || is_numeric($wasteDiversionPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wasteDiversionPercentage, true), gettype($wasteDiversionPercentage)), __LINE__);
        }
        $this->WasteDiversionPercentage = $wasteDiversionPercentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Water
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
