<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoluntaryChangesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies charges and/or penalties associated with making ticket changes after purchase.
 * @subpackage Structs
 */
class VoluntaryChangesType extends AbstractStructBase
{
    /**
     * The Penalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Penalty
     */
    public $Penalty;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The VolChangeInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator used to specify whether voluntary change and other penalties are involved in the search or response.
     * - use: optional
     * @var bool
     */
    public $VolChangeInd;
    /**
     * Constructor method for VoluntaryChangesType
     * @uses VoluntaryChangesType::setPenalty()
     * @uses VoluntaryChangesType::setTPA_Extensions()
     * @uses VoluntaryChangesType::setVolChangeInd()
     * @param \StructType\Penalty $penalty
     * @param mixed $tPA_Extensions
     * @param bool $volChangeInd
     */
    public function __construct(\StructType\Penalty $penalty = null, $tPA_Extensions = null, $volChangeInd = null)
    {
        $this
            ->setPenalty($penalty)
            ->setTPA_Extensions($tPA_Extensions)
            ->setVolChangeInd($volChangeInd);
    }
    /**
     * Get Penalty value
     * @return \StructType\Penalty|null
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * Set Penalty value
     * @param \StructType\Penalty $penalty
     * @return \StructType\VoluntaryChangesType
     */
    public function setPenalty(\StructType\Penalty $penalty = null)
    {
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VoluntaryChangesType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get VolChangeInd value
     * @return bool|null
     */
    public function getVolChangeInd()
    {
        return $this->VolChangeInd;
    }
    /**
     * Set VolChangeInd value
     * @param bool $volChangeInd
     * @return \StructType\VoluntaryChangesType
     */
    public function setVolChangeInd($volChangeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($volChangeInd) && !is_bool($volChangeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($volChangeInd, true), gettype($volChangeInd)), __LINE__);
        }
        $this->VolChangeInd = $volChangeInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VoluntaryChangesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
