<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewershipsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Viewerships determine the distribution channel(s) for a rate plan. As an optional element, the absence of Viewerships implies a generally available rate, while the presence of a Viewerships collection implies qualifications on the
 * rate. This may also be used to define a system that is able to view the hotel content.
 * @subpackage Structs
 */
class ViewershipsType extends AbstractStructBase
{
    /**
     * The Viewership
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Viewership[]
     */
    public $Viewership;
    /**
     * Constructor method for ViewershipsType
     * @uses ViewershipsType::setViewership()
     * @param \StructType\Viewership[] $viewership
     */
    public function __construct(array $viewership = array())
    {
        $this
            ->setViewership($viewership);
    }
    /**
     * Get Viewership value
     * @return \StructType\Viewership[]|null
     */
    public function getViewership()
    {
        return $this->Viewership;
    }
    /**
     * This method is responsible for validating the values passed to the setViewership method
     * This method is willingly generated in order to preserve the one-line inline validation within the setViewership method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateViewershipForArrayConstraintsFromSetViewership(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $viewershipsTypeViewershipItem) {
            // validation for constraint: itemType
            if (!$viewershipsTypeViewershipItem instanceof \StructType\Viewership) {
                $invalidValues[] = is_object($viewershipsTypeViewershipItem) ? get_class($viewershipsTypeViewershipItem) : sprintf('%s(%s)', gettype($viewershipsTypeViewershipItem), var_export($viewershipsTypeViewershipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Viewership property can only contain items of type \StructType\Viewership, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Viewership value
     * @throws \InvalidArgumentException
     * @param \StructType\Viewership[] $viewership
     * @return \StructType\ViewershipsType
     */
    public function setViewership(array $viewership = array())
    {
        // validation for constraint: array
        if ('' !== ($viewershipArrayErrorMessage = self::validateViewershipForArrayConstraintsFromSetViewership($viewership))) {
            throw new \InvalidArgumentException($viewershipArrayErrorMessage, __LINE__);
        }
        $this->Viewership = $viewership;
        return $this;
    }
    /**
     * Add item to Viewership value
     * @throws \InvalidArgumentException
     * @param \StructType\Viewership $item
     * @return \StructType\ViewershipsType
     */
    public function addToViewership(\StructType\Viewership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Viewership) {
            throw new \InvalidArgumentException(sprintf('The Viewership property can only contain items of type \StructType\Viewership, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Viewership[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ViewershipsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
