<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Viewership StructType
 * Meta information extracted from the WSDL
 * - documentation: Viewership defines a system that is allowed to view the rateplan identified in a Hotel Rate Plan Notification message. This may also be used to define a system that is able to view the hotel content.
 * @subpackage Structs
 */
class Viewership extends AbstractStructBase
{
    /**
     * The ViewershipCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ViewershipCodes
     */
    public $ViewershipCodes;
    /**
     * The SystemCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SystemCodes
     */
    public $SystemCodes;
    /**
     * The ProfileTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfileTypes
     */
    public $ProfileTypes;
    /**
     * The ProfileRefs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfileRefs
     */
    public $ProfileRefs;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Profiles
     */
    public $Profiles;
    /**
     * The LocationCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationCodes
     */
    public $LocationCodes;
    /**
     * The BookingChannelCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingChannelCodes
     */
    public $BookingChannelCodes;
    /**
     * The DistributorTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DistributorTypes
     */
    public $DistributorTypes;
    /**
     * The ViewershipRPH
     * Meta information extracted from the WSDL
     * - documentation: This is a reference placeholder, used as an index for multiple Viewership classes.
     * - use: optional
     * @var string
     */
    public $ViewershipRPH;
    /**
     * The ViewOnly
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this rate plan is bookable by the entity having viewership. Values: false= Bookable, true= View Only (not bookable).
     * - use: optional
     * @var bool
     */
    public $ViewOnly;
    /**
     * Constructor method for Viewership
     * @uses Viewership::setViewershipCodes()
     * @uses Viewership::setSystemCodes()
     * @uses Viewership::setProfileTypes()
     * @uses Viewership::setProfileRefs()
     * @uses Viewership::setProfiles()
     * @uses Viewership::setLocationCodes()
     * @uses Viewership::setBookingChannelCodes()
     * @uses Viewership::setDistributorTypes()
     * @uses Viewership::setViewershipRPH()
     * @uses Viewership::setViewOnly()
     * @param \StructType\ViewershipCodes $viewershipCodes
     * @param \StructType\SystemCodes $systemCodes
     * @param \StructType\ProfileTypes $profileTypes
     * @param \StructType\ProfileRefs $profileRefs
     * @param \StructType\Profiles $profiles
     * @param \StructType\LocationCodes $locationCodes
     * @param \StructType\BookingChannelCodes $bookingChannelCodes
     * @param \StructType\DistributorTypes $distributorTypes
     * @param string $viewershipRPH
     * @param bool $viewOnly
     */
    public function __construct(\StructType\ViewershipCodes $viewershipCodes = null, \StructType\SystemCodes $systemCodes = null, \StructType\ProfileTypes $profileTypes = null, \StructType\ProfileRefs $profileRefs = null, \StructType\Profiles $profiles = null, \StructType\LocationCodes $locationCodes = null, \StructType\BookingChannelCodes $bookingChannelCodes = null, \StructType\DistributorTypes $distributorTypes = null, $viewershipRPH = null, $viewOnly = null)
    {
        $this
            ->setViewershipCodes($viewershipCodes)
            ->setSystemCodes($systemCodes)
            ->setProfileTypes($profileTypes)
            ->setProfileRefs($profileRefs)
            ->setProfiles($profiles)
            ->setLocationCodes($locationCodes)
            ->setBookingChannelCodes($bookingChannelCodes)
            ->setDistributorTypes($distributorTypes)
            ->setViewershipRPH($viewershipRPH)
            ->setViewOnly($viewOnly);
    }
    /**
     * Get ViewershipCodes value
     * @return \StructType\ViewershipCodes|null
     */
    public function getViewershipCodes()
    {
        return $this->ViewershipCodes;
    }
    /**
     * Set ViewershipCodes value
     * @param \StructType\ViewershipCodes $viewershipCodes
     * @return \StructType\Viewership
     */
    public function setViewershipCodes(\StructType\ViewershipCodes $viewershipCodes = null)
    {
        $this->ViewershipCodes = $viewershipCodes;
        return $this;
    }
    /**
     * Get SystemCodes value
     * @return \StructType\SystemCodes|null
     */
    public function getSystemCodes()
    {
        return $this->SystemCodes;
    }
    /**
     * Set SystemCodes value
     * @param \StructType\SystemCodes $systemCodes
     * @return \StructType\Viewership
     */
    public function setSystemCodes(\StructType\SystemCodes $systemCodes = null)
    {
        $this->SystemCodes = $systemCodes;
        return $this;
    }
    /**
     * Get ProfileTypes value
     * @return \StructType\ProfileTypes|null
     */
    public function getProfileTypes()
    {
        return $this->ProfileTypes;
    }
    /**
     * Set ProfileTypes value
     * @param \StructType\ProfileTypes $profileTypes
     * @return \StructType\Viewership
     */
    public function setProfileTypes(\StructType\ProfileTypes $profileTypes = null)
    {
        $this->ProfileTypes = $profileTypes;
        return $this;
    }
    /**
     * Get ProfileRefs value
     * @return \StructType\ProfileRefs|null
     */
    public function getProfileRefs()
    {
        return $this->ProfileRefs;
    }
    /**
     * Set ProfileRefs value
     * @param \StructType\ProfileRefs $profileRefs
     * @return \StructType\Viewership
     */
    public function setProfileRefs(\StructType\ProfileRefs $profileRefs = null)
    {
        $this->ProfileRefs = $profileRefs;
        return $this;
    }
    /**
     * Get Profiles value
     * @return \StructType\Profiles|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \StructType\Profiles $profiles
     * @return \StructType\Viewership
     */
    public function setProfiles(\StructType\Profiles $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get LocationCodes value
     * @return \StructType\LocationCodes|null
     */
    public function getLocationCodes()
    {
        return $this->LocationCodes;
    }
    /**
     * Set LocationCodes value
     * @param \StructType\LocationCodes $locationCodes
     * @return \StructType\Viewership
     */
    public function setLocationCodes(\StructType\LocationCodes $locationCodes = null)
    {
        $this->LocationCodes = $locationCodes;
        return $this;
    }
    /**
     * Get BookingChannelCodes value
     * @return \StructType\BookingChannelCodes|null
     */
    public function getBookingChannelCodes()
    {
        return $this->BookingChannelCodes;
    }
    /**
     * Set BookingChannelCodes value
     * @param \StructType\BookingChannelCodes $bookingChannelCodes
     * @return \StructType\Viewership
     */
    public function setBookingChannelCodes(\StructType\BookingChannelCodes $bookingChannelCodes = null)
    {
        $this->BookingChannelCodes = $bookingChannelCodes;
        return $this;
    }
    /**
     * Get DistributorTypes value
     * @return \StructType\DistributorTypes|null
     */
    public function getDistributorTypes()
    {
        return $this->DistributorTypes;
    }
    /**
     * Set DistributorTypes value
     * @param \StructType\DistributorTypes $distributorTypes
     * @return \StructType\Viewership
     */
    public function setDistributorTypes(\StructType\DistributorTypes $distributorTypes = null)
    {
        $this->DistributorTypes = $distributorTypes;
        return $this;
    }
    /**
     * Get ViewershipRPH value
     * @return string|null
     */
    public function getViewershipRPH()
    {
        return $this->ViewershipRPH;
    }
    /**
     * Set ViewershipRPH value
     * @param string $viewershipRPH
     * @return \StructType\Viewership
     */
    public function setViewershipRPH($viewershipRPH = null)
    {
        // validation for constraint: string
        if (!is_null($viewershipRPH) && !is_string($viewershipRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewershipRPH, true), gettype($viewershipRPH)), __LINE__);
        }
        $this->ViewershipRPH = $viewershipRPH;
        return $this;
    }
    /**
     * Get ViewOnly value
     * @return bool|null
     */
    public function getViewOnly()
    {
        return $this->ViewOnly;
    }
    /**
     * Set ViewOnly value
     * @param bool $viewOnly
     * @return \StructType\Viewership
     */
    public function setViewOnly($viewOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewOnly) && !is_bool($viewOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($viewOnly, true), gettype($viewOnly)), __LINE__);
        }
        $this->ViewOnly = $viewOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Viewership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
