<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Multimedia information for the video item. | Details for a video of a given category.
 * @subpackage Structs
 */
class VideoItemType extends AbstractStructBase
{
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: URL of the multimedia item for a specific format.
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The UnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: The unit of measure associated with all the dimensions of the multimedia item. Refer to OpenTravel Code list Unit of Measure (UOM).
     * - use: optional
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: The width of the video item (unit specified by unit of measure).
     * - use: optional
     * @var int
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: The height of the video item (unit specified by unit of measure).
     * - use: optional
     * @var int
     */
    public $Height;
    /**
     * The BitRate
     * Meta information extracted from the WSDL
     * - documentation: The bit rate of the video item.
     * - use: optional
     * @var int
     */
    public $BitRate;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: The length of the video item (unit specified by unit of measure).
     * - use: optional
     * @var int
     */
    public $Length;
    /**
     * The StreamingSource
     * Meta information extracted from the WSDL
     * - documentation: Example: YouTube | Source website of the video.
     * @var string
     */
    public $StreamingSource;
    /**
     * Constructor method for VideoItemType
     * @uses VideoItemType::setURL()
     * @uses VideoItemType::setUnitOfMeasureCode()
     * @uses VideoItemType::setWidth()
     * @uses VideoItemType::setHeight()
     * @uses VideoItemType::setBitRate()
     * @uses VideoItemType::setLength()
     * @uses VideoItemType::setStreamingSource()
     * @param string $uRL
     * @param string $unitOfMeasureCode
     * @param int $width
     * @param int $height
     * @param int $bitRate
     * @param int $length
     * @param string $streamingSource
     */
    public function __construct($uRL = null, $unitOfMeasureCode = null, $width = null, $height = null, $bitRate = null, $length = null, $streamingSource = null)
    {
        $this
            ->setURL($uRL)
            ->setUnitOfMeasureCode($unitOfMeasureCode)
            ->setWidth($width)
            ->setHeight($height)
            ->setBitRate($bitRate)
            ->setLength($length)
            ->setStreamingSource($streamingSource);
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\VideoItemType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \StructType\VideoItemType
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \StructType\VideoItemType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\VideoItemType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get BitRate value
     * @return int|null
     */
    public function getBitRate()
    {
        return $this->BitRate;
    }
    /**
     * Set BitRate value
     * @param int $bitRate
     * @return \StructType\VideoItemType
     */
    public function setBitRate($bitRate = null)
    {
        // validation for constraint: int
        if (!is_null($bitRate) && !(is_int($bitRate) || ctype_digit($bitRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bitRate, true), gettype($bitRate)), __LINE__);
        }
        $this->BitRate = $bitRate;
        return $this;
    }
    /**
     * Get Length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \StructType\VideoItemType
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get StreamingSource value
     * @return string|null
     */
    public function getStreamingSource()
    {
        return $this->StreamingSource;
    }
    /**
     * Set StreamingSource value
     * @param string $streamingSource
     * @return \StructType\VideoItemType
     */
    public function setStreamingSource($streamingSource = null)
    {
        // validation for constraint: string
        if (!is_null($streamingSource) && !is_string($streamingSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streamingSource, true), gettype($streamingSource)), __LINE__);
        }
        $this->StreamingSource = $streamingSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VideoItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
