<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleSegmentAdditionalInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleSegmentAdditionalInfoType complex type identifies the data that descibes the supplemental information assocated with a vehicle segment. Such information may be associated with the reservation of a vehicle, but is not
 * normally included.
 * @subpackage Structs
 */
class VehicleSegmentAdditionalInfoType extends AbstractStructBase
{
    /**
     * The PaymentRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentRules
     */
    public $PaymentRules;
    /**
     * The RentalPaymentAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for payment information, may be prepayment, actual, etc.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RentalPaymentAmount;
    /**
     * The PricedCoverages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricedCoverages
     */
    public $PricedCoverages;
    /**
     * The PricedOffLocService
     * Meta information extracted from the WSDL
     * - documentation: Information on an off-location service associated with this reservation, along with the associated charge.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PricedOffLocService;
    /**
     * The VendorMessages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorMessages
     */
    public $VendorMessages;
    /**
     * The LocationDetails
     * Meta information extracted from the WSDL
     * - documentation: Detailed information about the associated rental facilities, for example, address, phone number, hours of operation.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LocationDetails;
    /**
     * The TourInfo
     * Meta information extracted from the WSDL
     * - documentation: Details of a tour associated with which this reservation information is associated. Rate information may vary if associated with a tour.
     * - minOccurs: 0
     * @var mixed
     */
    public $TourInfo;
    /**
     * The SpecialReqPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates the preference associated with special needs or requirements of the customer, described using free text.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SpecialReqPref;
    /**
     * The ArrivalDetails
     * Meta information extracted from the WSDL
     * - documentation: Details of the arrival transportation, if applicable.
     * - minOccurs: 0
     * @var mixed
     */
    public $ArrivalDetails;
    /**
     * The WrittenConfInst
     * Meta information extracted from the WSDL
     * - documentation: Used to provide instructions regarding cusotmer preferences for receiving confirmation information.
     * - minOccurs: 0
     * @var mixed
     */
    public $WrittenConfInst;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Free text description regarding the rental (e.g. vehicle is being rented because of an accident).
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Remark;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The WrittenConfInd
     * Meta information extracted from the WSDL
     * - documentation: When true, a written confirmation may be requested.
     * - use: optional
     * @var bool
     */
    public $WrittenConfInd;
    /**
     * Constructor method for VehicleSegmentAdditionalInfoType
     * @uses VehicleSegmentAdditionalInfoType::setPaymentRules()
     * @uses VehicleSegmentAdditionalInfoType::setRentalPaymentAmount()
     * @uses VehicleSegmentAdditionalInfoType::setPricedCoverages()
     * @uses VehicleSegmentAdditionalInfoType::setPricedOffLocService()
     * @uses VehicleSegmentAdditionalInfoType::setVendorMessages()
     * @uses VehicleSegmentAdditionalInfoType::setLocationDetails()
     * @uses VehicleSegmentAdditionalInfoType::setTourInfo()
     * @uses VehicleSegmentAdditionalInfoType::setSpecialReqPref()
     * @uses VehicleSegmentAdditionalInfoType::setArrivalDetails()
     * @uses VehicleSegmentAdditionalInfoType::setWrittenConfInst()
     * @uses VehicleSegmentAdditionalInfoType::setRemark()
     * @uses VehicleSegmentAdditionalInfoType::setTPA_Extensions()
     * @uses VehicleSegmentAdditionalInfoType::setWrittenConfInd()
     * @param \StructType\PaymentRules $paymentRules
     * @param mixed[] $rentalPaymentAmount
     * @param \StructType\PricedCoverages $pricedCoverages
     * @param mixed[] $pricedOffLocService
     * @param \StructType\VendorMessages $vendorMessages
     * @param mixed[] $locationDetails
     * @param mixed $tourInfo
     * @param mixed[] $specialReqPref
     * @param mixed $arrivalDetails
     * @param mixed $writtenConfInst
     * @param mixed[] $remark
     * @param mixed $tPA_Extensions
     * @param bool $writtenConfInd
     */
    public function __construct(\StructType\PaymentRules $paymentRules = null, array $rentalPaymentAmount = array(), \StructType\PricedCoverages $pricedCoverages = null, array $pricedOffLocService = array(), \StructType\VendorMessages $vendorMessages = null, array $locationDetails = array(), $tourInfo = null, array $specialReqPref = array(), $arrivalDetails = null, $writtenConfInst = null, array $remark = array(), $tPA_Extensions = null, $writtenConfInd = null)
    {
        $this
            ->setPaymentRules($paymentRules)
            ->setRentalPaymentAmount($rentalPaymentAmount)
            ->setPricedCoverages($pricedCoverages)
            ->setPricedOffLocService($pricedOffLocService)
            ->setVendorMessages($vendorMessages)
            ->setLocationDetails($locationDetails)
            ->setTourInfo($tourInfo)
            ->setSpecialReqPref($specialReqPref)
            ->setArrivalDetails($arrivalDetails)
            ->setWrittenConfInst($writtenConfInst)
            ->setRemark($remark)
            ->setTPA_Extensions($tPA_Extensions)
            ->setWrittenConfInd($writtenConfInd);
    }
    /**
     * Get PaymentRules value
     * @return \StructType\PaymentRules|null
     */
    public function getPaymentRules()
    {
        return $this->PaymentRules;
    }
    /**
     * Set PaymentRules value
     * @param \StructType\PaymentRules $paymentRules
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setPaymentRules(\StructType\PaymentRules $paymentRules = null)
    {
        $this->PaymentRules = $paymentRules;
        return $this;
    }
    /**
     * Get RentalPaymentAmount value
     * @return mixed[]|null
     */
    public function getRentalPaymentAmount()
    {
        return $this->RentalPaymentAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setRentalPaymentAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRentalPaymentAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRentalPaymentAmountForArrayConstraintsFromSetRentalPaymentAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem) ? get_class($vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem) : sprintf('%s(%s)', gettype($vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem), var_export($vehicleSegmentAdditionalInfoTypeRentalPaymentAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RentalPaymentAmount property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RentalPaymentAmount value
     * @throws \InvalidArgumentException
     * @param mixed[] $rentalPaymentAmount
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setRentalPaymentAmount(array $rentalPaymentAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($rentalPaymentAmountArrayErrorMessage = self::validateRentalPaymentAmountForArrayConstraintsFromSetRentalPaymentAmount($rentalPaymentAmount))) {
            throw new \InvalidArgumentException($rentalPaymentAmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($rentalPaymentAmount) && count($rentalPaymentAmount) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($rentalPaymentAmount)), __LINE__);
        }
        $this->RentalPaymentAmount = $rentalPaymentAmount;
        return $this;
    }
    /**
     * Add item to RentalPaymentAmount value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function addToRentalPaymentAmount($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RentalPaymentAmount property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RentalPaymentAmount) && count($this->RentalPaymentAmount) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RentalPaymentAmount)), __LINE__);
        }
        $this->RentalPaymentAmount[] = $item;
        return $this;
    }
    /**
     * Get PricedCoverages value
     * @return \StructType\PricedCoverages|null
     */
    public function getPricedCoverages()
    {
        return $this->PricedCoverages;
    }
    /**
     * Set PricedCoverages value
     * @param \StructType\PricedCoverages $pricedCoverages
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setPricedCoverages(\StructType\PricedCoverages $pricedCoverages = null)
    {
        $this->PricedCoverages = $pricedCoverages;
        return $this;
    }
    /**
     * Get PricedOffLocService value
     * @return mixed[]|null
     */
    public function getPricedOffLocService()
    {
        return $this->PricedOffLocService;
    }
    /**
     * This method is responsible for validating the values passed to the setPricedOffLocService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricedOffLocService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricedOffLocServiceForArrayConstraintsFromSetPricedOffLocService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem) ? get_class($vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem) : sprintf('%s(%s)', gettype($vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem), var_export($vehicleSegmentAdditionalInfoTypePricedOffLocServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricedOffLocService property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricedOffLocService value
     * @throws \InvalidArgumentException
     * @param mixed[] $pricedOffLocService
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setPricedOffLocService(array $pricedOffLocService = array())
    {
        // validation for constraint: array
        if ('' !== ($pricedOffLocServiceArrayErrorMessage = self::validatePricedOffLocServiceForArrayConstraintsFromSetPricedOffLocService($pricedOffLocService))) {
            throw new \InvalidArgumentException($pricedOffLocServiceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($pricedOffLocService) && count($pricedOffLocService) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($pricedOffLocService)), __LINE__);
        }
        $this->PricedOffLocService = $pricedOffLocService;
        return $this;
    }
    /**
     * Add item to PricedOffLocService value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function addToPricedOffLocService($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PricedOffLocService property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->PricedOffLocService) && count($this->PricedOffLocService) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->PricedOffLocService)), __LINE__);
        }
        $this->PricedOffLocService[] = $item;
        return $this;
    }
    /**
     * Get VendorMessages value
     * @return \StructType\VendorMessages|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param \StructType\VendorMessages $vendorMessages
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setVendorMessages(\StructType\VendorMessages $vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get LocationDetails value
     * @return mixed[]|null
     */
    public function getLocationDetails()
    {
        return $this->LocationDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationDetailsForArrayConstraintsFromSetLocationDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleSegmentAdditionalInfoTypeLocationDetailsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleSegmentAdditionalInfoTypeLocationDetailsItem) ? get_class($vehicleSegmentAdditionalInfoTypeLocationDetailsItem) : sprintf('%s(%s)', gettype($vehicleSegmentAdditionalInfoTypeLocationDetailsItem), var_export($vehicleSegmentAdditionalInfoTypeLocationDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LocationDetails property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocationDetails value
     * @throws \InvalidArgumentException
     * @param mixed[] $locationDetails
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setLocationDetails(array $locationDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($locationDetailsArrayErrorMessage = self::validateLocationDetailsForArrayConstraintsFromSetLocationDetails($locationDetails))) {
            throw new \InvalidArgumentException($locationDetailsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($locationDetails) && count($locationDetails) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($locationDetails)), __LINE__);
        }
        $this->LocationDetails = $locationDetails;
        return $this;
    }
    /**
     * Add item to LocationDetails value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function addToLocationDetails($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LocationDetails property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->LocationDetails) && count($this->LocationDetails) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->LocationDetails)), __LINE__);
        }
        $this->LocationDetails[] = $item;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return mixed|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param mixed $tourInfo
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setTourInfo($tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get SpecialReqPref value
     * @return mixed[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialReqPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialReqPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleSegmentAdditionalInfoTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleSegmentAdditionalInfoTypeSpecialReqPrefItem) ? get_class($vehicleSegmentAdditionalInfoTypeSpecialReqPrefItem) : sprintf('%s(%s)', gettype($vehicleSegmentAdditionalInfoTypeSpecialReqPrefItem), var_export($vehicleSegmentAdditionalInfoTypeSpecialReqPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialReqPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $specialReqPref
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specialReqPrefArrayErrorMessage = self::validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref($specialReqPref))) {
            throw new \InvalidArgumentException($specialReqPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($specialReqPref) && count($specialReqPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($specialReqPref)), __LINE__);
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function addToSpecialReqPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->SpecialReqPref) && count($this->SpecialReqPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->SpecialReqPref)), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get ArrivalDetails value
     * @return mixed|null
     */
    public function getArrivalDetails()
    {
        return $this->ArrivalDetails;
    }
    /**
     * Set ArrivalDetails value
     * @param mixed $arrivalDetails
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setArrivalDetails($arrivalDetails = null)
    {
        $this->ArrivalDetails = $arrivalDetails;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return mixed|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param mixed $writtenConfInst
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setWrittenConfInst($writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get Remark value
     * @return mixed[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleSegmentAdditionalInfoTypeRemarkItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleSegmentAdditionalInfoTypeRemarkItem) ? get_class($vehicleSegmentAdditionalInfoTypeRemarkItem) : sprintf('%s(%s)', gettype($vehicleSegmentAdditionalInfoTypeRemarkItem), var_export($vehicleSegmentAdditionalInfoTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param mixed[] $remark
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($remark) && count($remark) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function addToRemark($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Remark) && count($this->Remark) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Remark)), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get WrittenConfInd value
     * @return bool|null
     */
    public function getWrittenConfInd()
    {
        return $this->WrittenConfInd;
    }
    /**
     * Set WrittenConfInd value
     * @param bool $writtenConfInd
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public function setWrittenConfInd($writtenConfInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($writtenConfInd) && !is_bool($writtenConfInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($writtenConfInd, true), gettype($writtenConfInd)), __LINE__);
        }
        $this->WrittenConfInd = $writtenConfInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleSegmentAdditionalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
