<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalTransactionType StructType
 * Meta information extracted from the WSDL
 * - documentation: This contains the information typically used in a rental transaction, such as charges, contract number or pickup date/time.
 * @subpackage Structs
 */
class VehicleRentalTransactionType extends AbstractStructBase
{
    /**
     * The PickUpReturnDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\PickUpReturnDetails[]
     */
    public $PickUpReturnDetails;
    /**
     * The Vehicle
     * @var \StructType\Vehicle
     */
    public $Vehicle;
    /**
     * The RentalRate
     * Meta information extracted from the WSDL
     * - documentation: This describes time, mileage and other charges for a specific rental agreement.
     * - minOccurs: 0
     * @var mixed
     */
    public $RentalRate;
    /**
     * The PricedEquips
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricedEquips
     */
    public $PricedEquips;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fees
     */
    public $Fees;
    /**
     * The TotalCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalCharge
     */
    public $TotalCharge;
    /**
     * The ConfID
     * Meta information extracted from the WSDL
     * - documentation: A confirmation number.
     * - minOccurs: 0
     * @var mixed
     */
    public $ConfID;
    /**
     * The ContractID
     * Meta information extracted from the WSDL
     * - documentation: A contract number.
     * - minOccurs: 0
     * @var mixed
     */
    public $ContractID;
    /**
     * Constructor method for VehicleRentalTransactionType
     * @uses VehicleRentalTransactionType::setPickUpReturnDetails()
     * @uses VehicleRentalTransactionType::setVehicle()
     * @uses VehicleRentalTransactionType::setRentalRate()
     * @uses VehicleRentalTransactionType::setPricedEquips()
     * @uses VehicleRentalTransactionType::setFees()
     * @uses VehicleRentalTransactionType::setTotalCharge()
     * @uses VehicleRentalTransactionType::setConfID()
     * @uses VehicleRentalTransactionType::setContractID()
     * @param \StructType\PickUpReturnDetails[] $pickUpReturnDetails
     * @param \StructType\Vehicle $vehicle
     * @param mixed $rentalRate
     * @param \StructType\PricedEquips $pricedEquips
     * @param \StructType\Fees $fees
     * @param \StructType\TotalCharge $totalCharge
     * @param mixed $confID
     * @param mixed $contractID
     */
    public function __construct(array $pickUpReturnDetails = array(), \StructType\Vehicle $vehicle = null, $rentalRate = null, \StructType\PricedEquips $pricedEquips = null, \StructType\Fees $fees = null, \StructType\TotalCharge $totalCharge = null, $confID = null, $contractID = null)
    {
        $this
            ->setPickUpReturnDetails($pickUpReturnDetails)
            ->setVehicle($vehicle)
            ->setRentalRate($rentalRate)
            ->setPricedEquips($pricedEquips)
            ->setFees($fees)
            ->setTotalCharge($totalCharge)
            ->setConfID($confID)
            ->setContractID($contractID);
    }
    /**
     * Get PickUpReturnDetails value
     * @return \StructType\PickUpReturnDetails[]|null
     */
    public function getPickUpReturnDetails()
    {
        return $this->PickUpReturnDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setPickUpReturnDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickUpReturnDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePickUpReturnDetailsForArrayConstraintsFromSetPickUpReturnDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleRentalTransactionTypePickUpReturnDetailsItem) {
            // validation for constraint: itemType
            if (!$vehicleRentalTransactionTypePickUpReturnDetailsItem instanceof \StructType\PickUpReturnDetails) {
                $invalidValues[] = is_object($vehicleRentalTransactionTypePickUpReturnDetailsItem) ? get_class($vehicleRentalTransactionTypePickUpReturnDetailsItem) : sprintf('%s(%s)', gettype($vehicleRentalTransactionTypePickUpReturnDetailsItem), var_export($vehicleRentalTransactionTypePickUpReturnDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PickUpReturnDetails property can only contain items of type \StructType\PickUpReturnDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PickUpReturnDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\PickUpReturnDetails[] $pickUpReturnDetails
     * @return \StructType\VehicleRentalTransactionType
     */
    public function setPickUpReturnDetails(array $pickUpReturnDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($pickUpReturnDetailsArrayErrorMessage = self::validatePickUpReturnDetailsForArrayConstraintsFromSetPickUpReturnDetails($pickUpReturnDetails))) {
            throw new \InvalidArgumentException($pickUpReturnDetailsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($pickUpReturnDetails) && count($pickUpReturnDetails) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($pickUpReturnDetails)), __LINE__);
        }
        $this->PickUpReturnDetails = $pickUpReturnDetails;
        return $this;
    }
    /**
     * Add item to PickUpReturnDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\PickUpReturnDetails $item
     * @return \StructType\VehicleRentalTransactionType
     */
    public function addToPickUpReturnDetails(\StructType\PickUpReturnDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PickUpReturnDetails) {
            throw new \InvalidArgumentException(sprintf('The PickUpReturnDetails property can only contain items of type \StructType\PickUpReturnDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->PickUpReturnDetails) && count($this->PickUpReturnDetails) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->PickUpReturnDetails)), __LINE__);
        }
        $this->PickUpReturnDetails[] = $item;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\Vehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\Vehicle $vehicle
     * @return \StructType\VehicleRentalTransactionType
     */
    public function setVehicle(\StructType\Vehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get RentalRate value
     * @return mixed|null
     */
    public function getRentalRate()
    {
        return $this->RentalRate;
    }
    /**
     * Set RentalRate value
     * @param mixed $rentalRate
     * @return \StructType\VehicleRentalTransactionType
     */
    public function setRentalRate($rentalRate = null)
    {
        $this->RentalRate = $rentalRate;
        return $this;
    }
    /**
     * Get PricedEquips value
     * @return \StructType\PricedEquips|null
     */
    public function getPricedEquips()
    {
        return $this->PricedEquips;
    }
    /**
     * Set PricedEquips value
     * @param \StructType\PricedEquips $pricedEquips
     * @return \StructType\VehicleRentalTransactionType
     */
    public function setPricedEquips(\StructType\PricedEquips $pricedEquips = null)
    {
        $this->PricedEquips = $pricedEquips;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\Fees $fees
     * @return \StructType\VehicleRentalTransactionType
     */
    public function setFees(\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \StructType\TotalCharge|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @param \StructType\TotalCharge $totalCharge
     * @return \StructType\VehicleRentalTransactionType
     */
    public function setTotalCharge(\StructType\TotalCharge $totalCharge = null)
    {
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get ConfID value
     * @return mixed|null
     */
    public function getConfID()
    {
        return $this->ConfID;
    }
    /**
     * Set ConfID value
     * @param mixed $confID
     * @return \StructType\VehicleRentalTransactionType
     */
    public function setConfID($confID = null)
    {
        $this->ConfID = $confID;
        return $this;
    }
    /**
     * Get ContractID value
     * @return mixed|null
     */
    public function getContractID()
    {
        return $this->ContractID;
    }
    /**
     * Set ContractID value
     * @param mixed $contractID
     * @return \StructType\VehicleRentalTransactionType
     */
    public function setContractID($contractID = null)
    {
        $this->ContractID = $contractID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleRentalTransactionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
