<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: This provides specific information regarding the milage and condition of the vehicle being rented.
 * @subpackage Structs
 */
class VehicleRentalDetailsType extends AbstractStructBase
{
    /**
     * The FuelLevelDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FuelLevelDetails
     */
    public $FuelLevelDetails;
    /**
     * The OdometerReading
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OdometerReading
     */
    public $OdometerReading;
    /**
     * The ConditionReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\ConditionReport[]
     */
    public $ConditionReport;
    /**
     * The ParkingLocation
     * Meta information extracted from the WSDL
     * - documentation: This identifies the physical location of the vehicle being rented (e.g., the parking space or stall number).
     * - use: optional
     * @var string
     */
    public $ParkingLocation;
    /**
     * Constructor method for VehicleRentalDetailsType
     * @uses VehicleRentalDetailsType::setFuelLevelDetails()
     * @uses VehicleRentalDetailsType::setOdometerReading()
     * @uses VehicleRentalDetailsType::setConditionReport()
     * @uses VehicleRentalDetailsType::setParkingLocation()
     * @param \StructType\FuelLevelDetails $fuelLevelDetails
     * @param \StructType\OdometerReading $odometerReading
     * @param \StructType\ConditionReport[] $conditionReport
     * @param string $parkingLocation
     */
    public function __construct(\StructType\FuelLevelDetails $fuelLevelDetails = null, \StructType\OdometerReading $odometerReading = null, array $conditionReport = array(), $parkingLocation = null)
    {
        $this
            ->setFuelLevelDetails($fuelLevelDetails)
            ->setOdometerReading($odometerReading)
            ->setConditionReport($conditionReport)
            ->setParkingLocation($parkingLocation);
    }
    /**
     * Get FuelLevelDetails value
     * @return \StructType\FuelLevelDetails|null
     */
    public function getFuelLevelDetails()
    {
        return $this->FuelLevelDetails;
    }
    /**
     * Set FuelLevelDetails value
     * @param \StructType\FuelLevelDetails $fuelLevelDetails
     * @return \StructType\VehicleRentalDetailsType
     */
    public function setFuelLevelDetails(\StructType\FuelLevelDetails $fuelLevelDetails = null)
    {
        $this->FuelLevelDetails = $fuelLevelDetails;
        return $this;
    }
    /**
     * Get OdometerReading value
     * @return \StructType\OdometerReading|null
     */
    public function getOdometerReading()
    {
        return $this->OdometerReading;
    }
    /**
     * Set OdometerReading value
     * @param \StructType\OdometerReading $odometerReading
     * @return \StructType\VehicleRentalDetailsType
     */
    public function setOdometerReading(\StructType\OdometerReading $odometerReading = null)
    {
        $this->OdometerReading = $odometerReading;
        return $this;
    }
    /**
     * Get ConditionReport value
     * @return \StructType\ConditionReport[]|null
     */
    public function getConditionReport()
    {
        return $this->ConditionReport;
    }
    /**
     * This method is responsible for validating the values passed to the setConditionReport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConditionReport method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConditionReportForArrayConstraintsFromSetConditionReport(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleRentalDetailsTypeConditionReportItem) {
            // validation for constraint: itemType
            if (!$vehicleRentalDetailsTypeConditionReportItem instanceof \StructType\ConditionReport) {
                $invalidValues[] = is_object($vehicleRentalDetailsTypeConditionReportItem) ? get_class($vehicleRentalDetailsTypeConditionReportItem) : sprintf('%s(%s)', gettype($vehicleRentalDetailsTypeConditionReportItem), var_export($vehicleRentalDetailsTypeConditionReportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConditionReport property can only contain items of type \StructType\ConditionReport, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConditionReport value
     * @throws \InvalidArgumentException
     * @param \StructType\ConditionReport[] $conditionReport
     * @return \StructType\VehicleRentalDetailsType
     */
    public function setConditionReport(array $conditionReport = array())
    {
        // validation for constraint: array
        if ('' !== ($conditionReportArrayErrorMessage = self::validateConditionReportForArrayConstraintsFromSetConditionReport($conditionReport))) {
            throw new \InvalidArgumentException($conditionReportArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($conditionReport) && count($conditionReport) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($conditionReport)), __LINE__);
        }
        $this->ConditionReport = $conditionReport;
        return $this;
    }
    /**
     * Add item to ConditionReport value
     * @throws \InvalidArgumentException
     * @param \StructType\ConditionReport $item
     * @return \StructType\VehicleRentalDetailsType
     */
    public function addToConditionReport(\StructType\ConditionReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConditionReport) {
            throw new \InvalidArgumentException(sprintf('The ConditionReport property can only contain items of type \StructType\ConditionReport, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ConditionReport) && count($this->ConditionReport) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ConditionReport)), __LINE__);
        }
        $this->ConditionReport[] = $item;
        return $this;
    }
    /**
     * Get ParkingLocation value
     * @return string|null
     */
    public function getParkingLocation()
    {
        return $this->ParkingLocation;
    }
    /**
     * Set ParkingLocation value
     * @param string $parkingLocation
     * @return \StructType\VehicleRentalDetailsType
     */
    public function setParkingLocation($parkingLocation = null)
    {
        // validation for constraint: string
        if (!is_null($parkingLocation) && !is_string($parkingLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkingLocation, true), gettype($parkingLocation)), __LINE__);
        }
        $this->ParkingLocation = $parkingLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleRentalDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
