<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleLocationInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides formatted textual information relating to the vehicle rental location. The type of information is indicated in the @Type attribute that contains a value from the OpenTravel Vehicle Location Information Type (VLI) code list.
 * @subpackage Structs
 */
class VehicleLocationInformationType extends FormattedTextType
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of Vehicle Location information that is provided. Refer to OpenTravel Code List Vehicle Location Information Type (VLI).
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * Constructor method for VehicleLocationInformationType
     * @uses VehicleLocationInformationType::setType()
     * @param string $type
     */
    public function __construct($type = null)
    {
        $this
            ->setType($type);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\VehicleLocationInformationType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleLocationInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
