<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleLocationAdditionalFeesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Vehicle Location Additional Fees Type is used to define information on additional fees, taxes and surcharges that are included in the cost of a rental, when renting from this facility. Different facilities are required to impose
 * different fees and surcharges based upon location and local laws.
 * @subpackage Structs
 */
class VehicleLocationAdditionalFeesType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Taxes
     */
    public $Taxes;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fees
     */
    public $Fees;
    /**
     * The Surcharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Surcharges
     */
    public $Surcharges;
    /**
     * The MiscellaneousCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MiscellaneousCharges
     */
    public $MiscellaneousCharges;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for VehicleLocationAdditionalFeesType
     * @uses VehicleLocationAdditionalFeesType::setTaxes()
     * @uses VehicleLocationAdditionalFeesType::setFees()
     * @uses VehicleLocationAdditionalFeesType::setSurcharges()
     * @uses VehicleLocationAdditionalFeesType::setMiscellaneousCharges()
     * @uses VehicleLocationAdditionalFeesType::setTPA_Extensions()
     * @param \StructType\Taxes $taxes
     * @param \StructType\Fees $fees
     * @param \StructType\Surcharges $surcharges
     * @param \StructType\MiscellaneousCharges $miscellaneousCharges
     * @param mixed $tPA_Extensions
     */
    public function __construct(\StructType\Taxes $taxes = null, \StructType\Fees $fees = null, \StructType\Surcharges $surcharges = null, \StructType\MiscellaneousCharges $miscellaneousCharges = null, $tPA_Extensions = null)
    {
        $this
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setSurcharges($surcharges)
            ->setMiscellaneousCharges($miscellaneousCharges)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\Taxes $taxes
     * @return \StructType\VehicleLocationAdditionalFeesType
     */
    public function setTaxes(\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\Fees $fees
     * @return \StructType\VehicleLocationAdditionalFeesType
     */
    public function setFees(\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \StructType\Surcharges|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @param \StructType\Surcharges $surcharges
     * @return \StructType\VehicleLocationAdditionalFeesType
     */
    public function setSurcharges(\StructType\Surcharges $surcharges = null)
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
    /**
     * Get MiscellaneousCharges value
     * @return \StructType\MiscellaneousCharges|null
     */
    public function getMiscellaneousCharges()
    {
        return $this->MiscellaneousCharges;
    }
    /**
     * Set MiscellaneousCharges value
     * @param \StructType\MiscellaneousCharges $miscellaneousCharges
     * @return \StructType\VehicleLocationAdditionalFeesType
     */
    public function setMiscellaneousCharges(\StructType\MiscellaneousCharges $miscellaneousCharges = null)
    {
        $this->MiscellaneousCharges = $miscellaneousCharges;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VehicleLocationAdditionalFeesType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleLocationAdditionalFeesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
