<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Textual description about one specific aspect of the vehicles, for example, advanced booking needs, etc
 * @subpackage Structs
 */
class VehicleInfo extends FormattedTextType
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of Vehicle information that is provided..
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * Constructor method for VehicleInfo
     * @uses VehicleInfo::setType()
     * @param string $type
     */
    public function __construct($type = null)
    {
        $this
            ->setType($type);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\LocationDetailVehicleInfoType::valueIsValid()
     * @uses \EnumType\LocationDetailVehicleInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\VehicleInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationDetailVehicleInfoType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LocationDetailVehicleInfoType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\LocationDetailVehicleInfoType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
