<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleEquipmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleEquipmentType complex type identifies the data that fully describes a piece of special equipment, including the description and any restrictions that may apply to its rental.
 * @subpackage Structs
 */
class VehicleEquipmentType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Equipment description.
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Restriction
     * Meta information extracted from the WSDL
     * - documentation: Equipment restriction that may apply.
     * - use: optional
     * @var string
     */
    public $Restriction;
    /**
     * Constructor method for VehicleEquipmentType
     * @uses VehicleEquipmentType::setDescription()
     * @uses VehicleEquipmentType::setRestriction()
     * @param string $description
     * @param string $restriction
     */
    public function __construct($description = null, $restriction = null)
    {
        $this
            ->setDescription($description)
            ->setRestriction($restriction);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\VehicleEquipmentType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Restriction value
     * @return string|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * Set Restriction value
     * @uses \EnumType\EquipmentRestrictionType::valueIsValid()
     * @uses \EnumType\EquipmentRestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restriction
     * @return \StructType\VehicleEquipmentType
     */
    public function setRestriction($restriction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentRestrictionType::valueIsValid($restriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EquipmentRestrictionType', is_array($restriction) ? implode(', ', $restriction) : var_export($restriction, true), implode(', ', \EnumType\EquipmentRestrictionType::getValidValues())), __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleEquipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
