<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleChargeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies specific charges.
 * @subpackage Structs
 */
class VehicleChargeType extends AbstractStructBase
{
    /**
     * The TaxAmounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxAmounts
     */
    public $TaxAmounts;
    /**
     * The MinMax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MinMax
     */
    public $MinMax;
    /**
     * The Calculation
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Calculation[]
     */
    public $Calculation;
    /**
     * The TaxInclusive
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, taxes are included in this charge.
     * - use: optional
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description of the charge.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The GuaranteedInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, a guarantee payment or hold is required.
     * - use: optional
     * @var bool
     */
    public $GuaranteedInd;
    /**
     * The IncludedInRate
     * Meta information extracted from the WSDL
     * - documentation: false | An indication if this amount is included in the base vehicle rate, or is an additonal cost.
     * - use: optional
     * @var bool
     */
    public $IncludedInRate;
    /**
     * The IncludedInEstTotalInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the item's charges are included in the estimated total amount (in TotalCharge) and when false, the item is not included in the estimated total amount.
     * - use: optional
     * @var bool
     */
    public $IncludedInEstTotalInd;
    /**
     * The RateConvertInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the rate has been converted to a different currency.
     * - use: optional
     * @var bool
     */
    public $RateConvertInd;
    /**
     * Constructor method for VehicleChargeType
     * @uses VehicleChargeType::setTaxAmounts()
     * @uses VehicleChargeType::setMinMax()
     * @uses VehicleChargeType::setCalculation()
     * @uses VehicleChargeType::setTaxInclusive()
     * @uses VehicleChargeType::setDescription()
     * @uses VehicleChargeType::setGuaranteedInd()
     * @uses VehicleChargeType::setIncludedInRate()
     * @uses VehicleChargeType::setIncludedInEstTotalInd()
     * @uses VehicleChargeType::setRateConvertInd()
     * @param \StructType\TaxAmounts $taxAmounts
     * @param \StructType\MinMax $minMax
     * @param \StructType\Calculation[] $calculation
     * @param bool $taxInclusive
     * @param string $description
     * @param bool $guaranteedInd
     * @param bool $includedInRate
     * @param bool $includedInEstTotalInd
     * @param bool $rateConvertInd
     */
    public function __construct(\StructType\TaxAmounts $taxAmounts = null, \StructType\MinMax $minMax = null, array $calculation = array(), $taxInclusive = null, $description = null, $guaranteedInd = null, $includedInRate = null, $includedInEstTotalInd = null, $rateConvertInd = null)
    {
        $this
            ->setTaxAmounts($taxAmounts)
            ->setMinMax($minMax)
            ->setCalculation($calculation)
            ->setTaxInclusive($taxInclusive)
            ->setDescription($description)
            ->setGuaranteedInd($guaranteedInd)
            ->setIncludedInRate($includedInRate)
            ->setIncludedInEstTotalInd($includedInEstTotalInd)
            ->setRateConvertInd($rateConvertInd);
    }
    /**
     * Get TaxAmounts value
     * @return \StructType\TaxAmounts|null
     */
    public function getTaxAmounts()
    {
        return $this->TaxAmounts;
    }
    /**
     * Set TaxAmounts value
     * @param \StructType\TaxAmounts $taxAmounts
     * @return \StructType\VehicleChargeType
     */
    public function setTaxAmounts(\StructType\TaxAmounts $taxAmounts = null)
    {
        $this->TaxAmounts = $taxAmounts;
        return $this;
    }
    /**
     * Get MinMax value
     * @return \StructType\MinMax|null
     */
    public function getMinMax()
    {
        return $this->MinMax;
    }
    /**
     * Set MinMax value
     * @param \StructType\MinMax $minMax
     * @return \StructType\VehicleChargeType
     */
    public function setMinMax(\StructType\MinMax $minMax = null)
    {
        $this->MinMax = $minMax;
        return $this;
    }
    /**
     * Get Calculation value
     * @return \StructType\Calculation[]|null
     */
    public function getCalculation()
    {
        return $this->Calculation;
    }
    /**
     * This method is responsible for validating the values passed to the setCalculation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCalculation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCalculationForArrayConstraintsFromSetCalculation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleChargeTypeCalculationItem) {
            // validation for constraint: itemType
            if (!$vehicleChargeTypeCalculationItem instanceof \StructType\Calculation) {
                $invalidValues[] = is_object($vehicleChargeTypeCalculationItem) ? get_class($vehicleChargeTypeCalculationItem) : sprintf('%s(%s)', gettype($vehicleChargeTypeCalculationItem), var_export($vehicleChargeTypeCalculationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Calculation property can only contain items of type \StructType\Calculation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Calculation value
     * @throws \InvalidArgumentException
     * @param \StructType\Calculation[] $calculation
     * @return \StructType\VehicleChargeType
     */
    public function setCalculation(array $calculation = array())
    {
        // validation for constraint: array
        if ('' !== ($calculationArrayErrorMessage = self::validateCalculationForArrayConstraintsFromSetCalculation($calculation))) {
            throw new \InvalidArgumentException($calculationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($calculation) && count($calculation) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($calculation)), __LINE__);
        }
        $this->Calculation = $calculation;
        return $this;
    }
    /**
     * Add item to Calculation value
     * @throws \InvalidArgumentException
     * @param \StructType\Calculation $item
     * @return \StructType\VehicleChargeType
     */
    public function addToCalculation(\StructType\Calculation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Calculation) {
            throw new \InvalidArgumentException(sprintf('The Calculation property can only contain items of type \StructType\Calculation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Calculation) && count($this->Calculation) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Calculation)), __LINE__);
        }
        $this->Calculation[] = $item;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \StructType\VehicleChargeType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\VehicleChargeType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get GuaranteedInd value
     * @return bool|null
     */
    public function getGuaranteedInd()
    {
        return $this->GuaranteedInd;
    }
    /**
     * Set GuaranteedInd value
     * @param bool $guaranteedInd
     * @return \StructType\VehicleChargeType
     */
    public function setGuaranteedInd($guaranteedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteedInd) && !is_bool($guaranteedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteedInd, true), gettype($guaranteedInd)), __LINE__);
        }
        $this->GuaranteedInd = $guaranteedInd;
        return $this;
    }
    /**
     * Get IncludedInRate value
     * @return bool|null
     */
    public function getIncludedInRate()
    {
        return $this->IncludedInRate;
    }
    /**
     * Set IncludedInRate value
     * @param bool $includedInRate
     * @return \StructType\VehicleChargeType
     */
    public function setIncludedInRate($includedInRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($includedInRate) && !is_bool($includedInRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includedInRate, true), gettype($includedInRate)), __LINE__);
        }
        $this->IncludedInRate = $includedInRate;
        return $this;
    }
    /**
     * Get IncludedInEstTotalInd value
     * @return bool|null
     */
    public function getIncludedInEstTotalInd()
    {
        return $this->IncludedInEstTotalInd;
    }
    /**
     * Set IncludedInEstTotalInd value
     * @param bool $includedInEstTotalInd
     * @return \StructType\VehicleChargeType
     */
    public function setIncludedInEstTotalInd($includedInEstTotalInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($includedInEstTotalInd) && !is_bool($includedInEstTotalInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includedInEstTotalInd, true), gettype($includedInEstTotalInd)), __LINE__);
        }
        $this->IncludedInEstTotalInd = $includedInEstTotalInd;
        return $this;
    }
    /**
     * Get RateConvertInd value
     * @return bool|null
     */
    public function getRateConvertInd()
    {
        return $this->RateConvertInd;
    }
    /**
     * Set RateConvertInd value
     * @param bool $rateConvertInd
     * @return \StructType\VehicleChargeType
     */
    public function setRateConvertInd($rateConvertInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateConvertInd) && !is_bool($rateConvertInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateConvertInd, true), gettype($rateConvertInd)), __LINE__);
        }
        $this->RateConvertInd = $rateConvertInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
