<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailCoreType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleAvailCoreType complex type identifies the data that describes common, or core, information made available as part of describing the availability and rate of one or more vehicles.
 * @subpackage Structs
 */
class VehicleAvailCoreType extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - documentation: Information on one specific vehicle along with detailed information on the charges associated with this vehicle.
     * @var mixed
     */
    public $Vehicle;
    /**
     * The RentalRate
     * Meta information extracted from the WSDL
     * - documentation: Information on the rates associated with this vehicle. Rate information can include the distance and the base rental cost, along with information on the various factors that may infuence this rate. This element may repeat to allow
     * different distances to be made available for different charges. For example, $20.00 with 100 miles per day or $30.00 for unlimited mileage.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RentalRate;
    /**
     * The TotalCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\TotalCharge[]
     */
    public $TotalCharge;
    /**
     * The PricedEquips
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricedEquips
     */
    public $PricedEquips;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fees
     */
    public $Fees;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $Reference;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Vendor
     */
    public $Vendor;
    /**
     * The VendorLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorLocation
     */
    public $VendorLocation;
    /**
     * The DropOffLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DropOffLocation
     */
    public $DropOffLocation;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Discount[]
     */
    public $Discount;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The IsAlternateInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this vehicle is an alternate to what was requested.
     * - use: optional
     * @var bool
     */
    public $IsAlternateInd;
    /**
     * Constructor method for VehicleAvailCoreType
     * @uses VehicleAvailCoreType::setStatus()
     * @uses VehicleAvailCoreType::setVehicle()
     * @uses VehicleAvailCoreType::setRentalRate()
     * @uses VehicleAvailCoreType::setTotalCharge()
     * @uses VehicleAvailCoreType::setPricedEquips()
     * @uses VehicleAvailCoreType::setFees()
     * @uses VehicleAvailCoreType::setReference()
     * @uses VehicleAvailCoreType::setVendor()
     * @uses VehicleAvailCoreType::setVendorLocation()
     * @uses VehicleAvailCoreType::setDropOffLocation()
     * @uses VehicleAvailCoreType::setDiscount()
     * @uses VehicleAvailCoreType::setTPA_Extensions()
     * @uses VehicleAvailCoreType::setIsAlternateInd()
     * @param string $status
     * @param mixed $vehicle
     * @param mixed[] $rentalRate
     * @param \StructType\TotalCharge[] $totalCharge
     * @param \StructType\PricedEquips $pricedEquips
     * @param \StructType\Fees $fees
     * @param \StructType\Reference $reference
     * @param \StructType\Vendor $vendor
     * @param \StructType\VendorLocation $vendorLocation
     * @param \StructType\DropOffLocation $dropOffLocation
     * @param \StructType\Discount[] $discount
     * @param mixed $tPA_Extensions
     * @param bool $isAlternateInd
     */
    public function __construct($status = null, $vehicle = null, array $rentalRate = array(), array $totalCharge = array(), \StructType\PricedEquips $pricedEquips = null, \StructType\Fees $fees = null, \StructType\Reference $reference = null, \StructType\Vendor $vendor = null, \StructType\VendorLocation $vendorLocation = null, \StructType\DropOffLocation $dropOffLocation = null, array $discount = array(), $tPA_Extensions = null, $isAlternateInd = null)
    {
        $this
            ->setStatus($status)
            ->setVehicle($vehicle)
            ->setRentalRate($rentalRate)
            ->setTotalCharge($totalCharge)
            ->setPricedEquips($pricedEquips)
            ->setFees($fees)
            ->setReference($reference)
            ->setVendor($vendor)
            ->setVendorLocation($vendorLocation)
            ->setDropOffLocation($dropOffLocation)
            ->setDiscount($discount)
            ->setTPA_Extensions($tPA_Extensions)
            ->setIsAlternateInd($isAlternateInd);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\InventoryStatusType::valueIsValid()
     * @uses \EnumType\InventoryStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\VehicleAvailCoreType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InventoryStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InventoryStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\InventoryStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return mixed|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param mixed $vehicle
     * @return \StructType\VehicleAvailCoreType
     */
    public function setVehicle($vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get RentalRate value
     * @return mixed[]|null
     */
    public function getRentalRate()
    {
        return $this->RentalRate;
    }
    /**
     * This method is responsible for validating the values passed to the setRentalRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRentalRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRentalRateForArrayConstraintsFromSetRentalRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailCoreTypeRentalRateItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleAvailCoreTypeRentalRateItem) ? get_class($vehicleAvailCoreTypeRentalRateItem) : sprintf('%s(%s)', gettype($vehicleAvailCoreTypeRentalRateItem), var_export($vehicleAvailCoreTypeRentalRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RentalRate property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RentalRate value
     * @throws \InvalidArgumentException
     * @param mixed[] $rentalRate
     * @return \StructType\VehicleAvailCoreType
     */
    public function setRentalRate(array $rentalRate = array())
    {
        // validation for constraint: array
        if ('' !== ($rentalRateArrayErrorMessage = self::validateRentalRateForArrayConstraintsFromSetRentalRate($rentalRate))) {
            throw new \InvalidArgumentException($rentalRateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($rentalRate) && count($rentalRate) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($rentalRate)), __LINE__);
        }
        $this->RentalRate = $rentalRate;
        return $this;
    }
    /**
     * Add item to RentalRate value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleAvailCoreType
     */
    public function addToRentalRate($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RentalRate property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RentalRate) && count($this->RentalRate) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RentalRate)), __LINE__);
        }
        $this->RentalRate[] = $item;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \StructType\TotalCharge[]|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalChargeForArrayConstraintsFromSetTotalCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailCoreTypeTotalChargeItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailCoreTypeTotalChargeItem instanceof \StructType\TotalCharge) {
                $invalidValues[] = is_object($vehicleAvailCoreTypeTotalChargeItem) ? get_class($vehicleAvailCoreTypeTotalChargeItem) : sprintf('%s(%s)', gettype($vehicleAvailCoreTypeTotalChargeItem), var_export($vehicleAvailCoreTypeTotalChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalCharge property can only contain items of type \StructType\TotalCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalCharge[] $totalCharge
     * @return \StructType\VehicleAvailCoreType
     */
    public function setTotalCharge(array $totalCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($totalChargeArrayErrorMessage = self::validateTotalChargeForArrayConstraintsFromSetTotalCharge($totalCharge))) {
            throw new \InvalidArgumentException($totalChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($totalCharge) && count($totalCharge) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($totalCharge)), __LINE__);
        }
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Add item to TotalCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalCharge $item
     * @return \StructType\VehicleAvailCoreType
     */
    public function addToTotalCharge(\StructType\TotalCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TotalCharge) {
            throw new \InvalidArgumentException(sprintf('The TotalCharge property can only contain items of type \StructType\TotalCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->TotalCharge) && count($this->TotalCharge) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->TotalCharge)), __LINE__);
        }
        $this->TotalCharge[] = $item;
        return $this;
    }
    /**
     * Get PricedEquips value
     * @return \StructType\PricedEquips|null
     */
    public function getPricedEquips()
    {
        return $this->PricedEquips;
    }
    /**
     * Set PricedEquips value
     * @param \StructType\PricedEquips $pricedEquips
     * @return \StructType\VehicleAvailCoreType
     */
    public function setPricedEquips(\StructType\PricedEquips $pricedEquips = null)
    {
        $this->PricedEquips = $pricedEquips;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\Fees $fees
     * @return \StructType\VehicleAvailCoreType
     */
    public function setFees(\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\Reference $reference
     * @return \StructType\VehicleAvailCoreType
     */
    public function setReference(\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \StructType\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \StructType\Vendor $vendor
     * @return \StructType\VehicleAvailCoreType
     */
    public function setVendor(\StructType\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get VendorLocation value
     * @return \StructType\VendorLocation|null
     */
    public function getVendorLocation()
    {
        return $this->VendorLocation;
    }
    /**
     * Set VendorLocation value
     * @param \StructType\VendorLocation $vendorLocation
     * @return \StructType\VehicleAvailCoreType
     */
    public function setVendorLocation(\StructType\VendorLocation $vendorLocation = null)
    {
        $this->VendorLocation = $vendorLocation;
        return $this;
    }
    /**
     * Get DropOffLocation value
     * @return \StructType\DropOffLocation|null
     */
    public function getDropOffLocation()
    {
        return $this->DropOffLocation;
    }
    /**
     * Set DropOffLocation value
     * @param \StructType\DropOffLocation $dropOffLocation
     * @return \StructType\VehicleAvailCoreType
     */
    public function setDropOffLocation(\StructType\DropOffLocation $dropOffLocation = null)
    {
        $this->DropOffLocation = $dropOffLocation;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\Discount[]|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountForArrayConstraintsFromSetDiscount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailCoreTypeDiscountItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailCoreTypeDiscountItem instanceof \StructType\Discount) {
                $invalidValues[] = is_object($vehicleAvailCoreTypeDiscountItem) ? get_class($vehicleAvailCoreTypeDiscountItem) : sprintf('%s(%s)', gettype($vehicleAvailCoreTypeDiscountItem), var_export($vehicleAvailCoreTypeDiscountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Discount property can only contain items of type \StructType\Discount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Discount value
     * @throws \InvalidArgumentException
     * @param \StructType\Discount[] $discount
     * @return \StructType\VehicleAvailCoreType
     */
    public function setDiscount(array $discount = array())
    {
        // validation for constraint: array
        if ('' !== ($discountArrayErrorMessage = self::validateDiscountForArrayConstraintsFromSetDiscount($discount))) {
            throw new \InvalidArgumentException($discountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($discount) && count($discount) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Add item to Discount value
     * @throws \InvalidArgumentException
     * @param \StructType\Discount $item
     * @return \StructType\VehicleAvailCoreType
     */
    public function addToDiscount(\StructType\Discount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Discount) {
            throw new \InvalidArgumentException(sprintf('The Discount property can only contain items of type \StructType\Discount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Discount) && count($this->Discount) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Discount)), __LINE__);
        }
        $this->Discount[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VehicleAvailCoreType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get IsAlternateInd value
     * @return bool|null
     */
    public function getIsAlternateInd()
    {
        return $this->IsAlternateInd;
    }
    /**
     * Set IsAlternateInd value
     * @param bool $isAlternateInd
     * @return \StructType\VehicleAvailCoreType
     */
    public function setIsAlternateInd($isAlternateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternateInd) && !is_bool($isAlternateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlternateInd, true), gettype($isAlternateInd)), __LINE__);
        }
        $this->IsAlternateInd = $isAlternateInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleAvailCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
