<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicle StructType
 * Meta information extracted from the WSDL
 * - documentation: Vehicle info including size, class, make/model, vehicle asset number, etc. This is the actual vehicle being rented. | Specific information about a vehicle that is offered for rental at this facility. This element may repeat to
 * identify all vehicles that may be rented from this facility. | This element may be used to clarify the vehicle associated with this charge, if the charge varies by vehicle type. | Identifies a specific vehicle type. | To identify a vehicle type
 * associated with additional driver information. | Vehicle information.
 * @subpackage Structs
 */
class Vehicle extends VehicleType
{
    /**
     * The Class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\_Class
     */
    public $Class;
    /**
     * The Make
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Make
     */
    public $Make;
    /**
     * The Model
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Model
     */
    public $Model;
    /**
     * The IncludeExclude
     * Meta information extracted from the WSDL
     * - documentation: To indicate if the coverage is required, allowed, included, or excluded for this vehicle type. | To specify if this car type is allowed, required, included, excluded for the associated age. | To specify if this vehicle type is
     * allowed, required, excluded, or included for an additional driver.
     * - use: optional
     * @var string
     */
    public $IncludeExclude;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Free text information for this vehicle type.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Text;
    /**
     * The IsConfirmableInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this car type may be confirmed. If false, it may not be confirmed.
     * - use: optional
     * @var bool
     */
    public $IsConfirmableInd;
    /**
     * The DistanceUnit
     * Meta information extracted from the WSDL
     * - documentation: To specify whether mileage information is miles or kilometers.
     * - use: optional
     * @var string
     */
    public $DistanceUnit;
    /**
     * The DistancePerFuelUnit
     * Meta information extracted from the WSDL
     * - documentation: To specify the number of miles/kilometers per gallon/litre of gas.
     * - use: optional
     * @var int
     */
    public $DistancePerFuelUnit;
    /**
     * The VehRentalDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $VehRentalDetails;
    /**
     * Constructor method for Vehicle
     * @uses Vehicle::setClass()
     * @uses Vehicle::setMake()
     * @uses Vehicle::setModel()
     * @uses Vehicle::setIncludeExclude()
     * @uses Vehicle::setText()
     * @uses Vehicle::setIsConfirmableInd()
     * @uses Vehicle::setDistanceUnit()
     * @uses Vehicle::setDistancePerFuelUnit()
     * @uses Vehicle::setVehRentalDetails()
     * @param \StructType\_Class $class
     * @param \StructType\Make $make
     * @param \StructType\Model $model
     * @param string $includeExclude
     * @param mixed[] $text
     * @param bool $isConfirmableInd
     * @param string $distanceUnit
     * @param int $distancePerFuelUnit
     * @param mixed[] $vehRentalDetails
     */
    public function __construct(\StructType\_Class $class = null, \StructType\Make $make = null, \StructType\Model $model = null, $includeExclude = null, array $text = array(), $isConfirmableInd = null, $distanceUnit = null, $distancePerFuelUnit = null, array $vehRentalDetails = array())
    {
        $this
            ->setClass($class)
            ->setMake($make)
            ->setModel($model)
            ->setIncludeExclude($includeExclude)
            ->setText($text)
            ->setIsConfirmableInd($isConfirmableInd)
            ->setDistanceUnit($distanceUnit)
            ->setDistancePerFuelUnit($distancePerFuelUnit)
            ->setVehRentalDetails($vehRentalDetails);
    }
    /**
     * Get Class value
     * @return \StructType\_Class|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param \StructType\_Class $class
     * @return \StructType\Vehicle
     */
    public function setClass(\StructType\_Class $class = null)
    {
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Make value
     * @return \StructType\Make|null
     */
    public function getMake()
    {
        return $this->Make;
    }
    /**
     * Set Make value
     * @param \StructType\Make $make
     * @return \StructType\Vehicle
     */
    public function setMake(\StructType\Make $make = null)
    {
        $this->Make = $make;
        return $this;
    }
    /**
     * Get Model value
     * @return \StructType\Model|null
     */
    public function getModel()
    {
        return $this->Model;
    }
    /**
     * Set Model value
     * @param \StructType\Model $model
     * @return \StructType\Vehicle
     */
    public function setModel(\StructType\Model $model = null)
    {
        $this->Model = $model;
        return $this;
    }
    /**
     * Get IncludeExclude value
     * @return string|null
     */
    public function getIncludeExclude()
    {
        return $this->IncludeExclude;
    }
    /**
     * Set IncludeExclude value
     * @uses \EnumType\IncludeExcludeType::valueIsValid()
     * @uses \EnumType\IncludeExcludeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeExclude
     * @return \StructType\Vehicle
     */
    public function setIncludeExclude($includeExclude = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IncludeExcludeType::valueIsValid($includeExclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IncludeExcludeType', is_array($includeExclude) ? implode(', ', $includeExclude) : var_export($includeExclude, true), implode(', ', \EnumType\IncludeExcludeType::getValidValues())), __LINE__);
        }
        $this->IncludeExclude = $includeExclude;
        return $this;
    }
    /**
     * Get Text value
     * @return mixed[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * This method is responsible for validating the values passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextForArrayConstraintsFromSetText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleTextItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleTextItem) ? get_class($vehicleTextItem) : sprintf('%s(%s)', gettype($vehicleTextItem), var_export($vehicleTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Text property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param mixed[] $text
     * @return \StructType\Vehicle
     */
    public function setText(array $text = array())
    {
        // validation for constraint: array
        if ('' !== ($textArrayErrorMessage = self::validateTextForArrayConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($text) && count($text) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Vehicle
     */
    public function addToText($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Text property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Text) && count($this->Text) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Text)), __LINE__);
        }
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get IsConfirmableInd value
     * @return bool|null
     */
    public function getIsConfirmableInd()
    {
        return $this->IsConfirmableInd;
    }
    /**
     * Set IsConfirmableInd value
     * @param bool $isConfirmableInd
     * @return \StructType\Vehicle
     */
    public function setIsConfirmableInd($isConfirmableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmableInd) && !is_bool($isConfirmableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmableInd, true), gettype($isConfirmableInd)), __LINE__);
        }
        $this->IsConfirmableInd = $isConfirmableInd;
        return $this;
    }
    /**
     * Get DistanceUnit value
     * @return string|null
     */
    public function getDistanceUnit()
    {
        return $this->DistanceUnit;
    }
    /**
     * Set DistanceUnit value
     * @uses \EnumType\DistanceUnitNameType::valueIsValid()
     * @uses \EnumType\DistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distanceUnit
     * @return \StructType\Vehicle
     */
    public function setDistanceUnit($distanceUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnitNameType::valueIsValid($distanceUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistanceUnitNameType', is_array($distanceUnit) ? implode(', ', $distanceUnit) : var_export($distanceUnit, true), implode(', ', \EnumType\DistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->DistanceUnit = $distanceUnit;
        return $this;
    }
    /**
     * Get DistancePerFuelUnit value
     * @return int|null
     */
    public function getDistancePerFuelUnit()
    {
        return $this->DistancePerFuelUnit;
    }
    /**
     * Set DistancePerFuelUnit value
     * @param int $distancePerFuelUnit
     * @return \StructType\Vehicle
     */
    public function setDistancePerFuelUnit($distancePerFuelUnit = null)
    {
        // validation for constraint: int
        if (!is_null($distancePerFuelUnit) && !(is_int($distancePerFuelUnit) || ctype_digit($distancePerFuelUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distancePerFuelUnit, true), gettype($distancePerFuelUnit)), __LINE__);
        }
        $this->DistancePerFuelUnit = $distancePerFuelUnit;
        return $this;
    }
    /**
     * Get VehRentalDetails value
     * @return mixed[]|null
     */
    public function getVehRentalDetails()
    {
        return $this->VehRentalDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setVehRentalDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehRentalDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehRentalDetailsForArrayConstraintsFromSetVehRentalDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleVehRentalDetailsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleVehRentalDetailsItem) ? get_class($vehicleVehRentalDetailsItem) : sprintf('%s(%s)', gettype($vehicleVehRentalDetailsItem), var_export($vehicleVehRentalDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehRentalDetails property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehRentalDetails value
     * @throws \InvalidArgumentException
     * @param mixed[] $vehRentalDetails
     * @return \StructType\Vehicle
     */
    public function setVehRentalDetails(array $vehRentalDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($vehRentalDetailsArrayErrorMessage = self::validateVehRentalDetailsForArrayConstraintsFromSetVehRentalDetails($vehRentalDetails))) {
            throw new \InvalidArgumentException($vehRentalDetailsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($vehRentalDetails) && count($vehRentalDetails) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($vehRentalDetails)), __LINE__);
        }
        $this->VehRentalDetails = $vehRentalDetails;
        return $this;
    }
    /**
     * Add item to VehRentalDetails value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Vehicle
     */
    public function addToVehRentalDetails($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The VehRentalDetails property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->VehRentalDetails) && count($this->VehRentalDetails) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->VehRentalDetails)), __LINE__);
        }
        $this->VehRentalDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vehicle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
