<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehVendorAvails StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of vendors for which vehicle availability is available.
 * @subpackage Structs
 */
class VehVendorAvails extends AbstractStructBase
{
    /**
     * The VehVendorAvail
     * Meta information extracted from the WSDL
     * - documentation: Information on the availability of rental vehicles for one specific vendor.
     * - maxOccurs: 20
     * @var mixed[]
     */
    public $VehVendorAvail;
    /**
     * Constructor method for VehVendorAvails
     * @uses VehVendorAvails::setVehVendorAvail()
     * @param mixed[] $vehVendorAvail
     */
    public function __construct(array $vehVendorAvail = array())
    {
        $this
            ->setVehVendorAvail($vehVendorAvail);
    }
    /**
     * Get VehVendorAvail value
     * @return mixed[]|null
     */
    public function getVehVendorAvail()
    {
        return $this->VehVendorAvail;
    }
    /**
     * This method is responsible for validating the values passed to the setVehVendorAvail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehVendorAvail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehVendorAvailForArrayConstraintsFromSetVehVendorAvail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehVendorAvailsVehVendorAvailItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehVendorAvailsVehVendorAvailItem) ? get_class($vehVendorAvailsVehVendorAvailItem) : sprintf('%s(%s)', gettype($vehVendorAvailsVehVendorAvailItem), var_export($vehVendorAvailsVehVendorAvailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehVendorAvail property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehVendorAvail value
     * @throws \InvalidArgumentException
     * @param mixed[] $vehVendorAvail
     * @return \StructType\VehVendorAvails
     */
    public function setVehVendorAvail(array $vehVendorAvail = array())
    {
        // validation for constraint: array
        if ('' !== ($vehVendorAvailArrayErrorMessage = self::validateVehVendorAvailForArrayConstraintsFromSetVehVendorAvail($vehVendorAvail))) {
            throw new \InvalidArgumentException($vehVendorAvailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($vehVendorAvail) && count($vehVendorAvail) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($vehVendorAvail)), __LINE__);
        }
        $this->VehVendorAvail = $vehVendorAvail;
        return $this;
    }
    /**
     * Add item to VehVendorAvail value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehVendorAvails
     */
    public function addToVehVendorAvail($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The VehVendorAvail property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->VehVendorAvail) && count($this->VehVendorAvail) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->VehVendorAvail)), __LINE__);
        }
        $this->VehVendorAvail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehVendorAvails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
