<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehNotifReportRQCore StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the common, or core, information associated with the request providing information on the reservation of a rental vehicle.
 * @subpackage Structs
 */
class VehNotifReportRQCore extends VehicleResRSCoreType
{
    /**
     * The ReservationStatus
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReservationStatus;
    /**
     * Constructor method for VehNotifReportRQCore
     * @uses VehNotifReportRQCore::setReservationStatus()
     * @param string $reservationStatus
     */
    public function __construct($reservationStatus = null)
    {
        $this
            ->setReservationStatus($reservationStatus);
    }
    /**
     * Get ReservationStatus value
     * @return string|null
     */
    public function getReservationStatus()
    {
        return $this->ReservationStatus;
    }
    /**
     * Set ReservationStatus value
     * @param string $reservationStatus
     * @return \StructType\VehNotifReportRQCore
     */
    public function setReservationStatus($reservationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($reservationStatus) && !is_string($reservationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationStatus, true), gettype($reservationStatus)), __LINE__);
        }
        $this->ReservationStatus = $reservationStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehNotifReportRQCore
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
