<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserGeneratedContent StructType
 * Meta information extracted from the WSDL
 * - documentation: Information linked to user content.
 * @subpackage Structs
 */
class UserGeneratedContent extends AbstractStructBase
{
    /**
     * The TypeOfRating
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TypeOfRating;
    /**
     * The Rating
     * Meta information extracted from the WSDL
     * - documentation: User rating for the property on which the search is made.
     * - use: optional
     * @var int
     */
    public $Rating;
    /**
     * Constructor method for UserGeneratedContent
     * @uses UserGeneratedContent::setTypeOfRating()
     * @uses UserGeneratedContent::setRating()
     * @param string $typeOfRating
     * @param int $rating
     */
    public function __construct($typeOfRating = null, $rating = null)
    {
        $this
            ->setTypeOfRating($typeOfRating)
            ->setRating($rating);
    }
    /**
     * Get TypeOfRating value
     * @return string|null
     */
    public function getTypeOfRating()
    {
        return $this->TypeOfRating;
    }
    /**
     * Set TypeOfRating value
     * @param string $typeOfRating
     * @return \StructType\UserGeneratedContent
     */
    public function setTypeOfRating($typeOfRating = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfRating) && !is_string($typeOfRating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeOfRating, true), gettype($typeOfRating)), __LINE__);
        }
        $this->TypeOfRating = $typeOfRating;
        return $this;
    }
    /**
     * Get Rating value
     * @return int|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param int $rating
     * @return \StructType\UserGeneratedContent
     */
    public function setRating($rating = null)
    {
        // validation for constraint: int
        if (!is_null($rating) && !(is_int($rating) || ctype_digit($rating))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserGeneratedContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
