<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnstructuredFareCalc StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the fare calc information for the stored fare for the passenger. | Contains the fare calculation information for the stored passenger fare.
 * @subpackage Structs
 */
class UnstructuredFareCalc extends AbstractStructBase
{
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: The fare calculation area.
     * - use: required
     * @var string
     */
    public $Info;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The FareCalcMode
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the method of pricing for this transaction (e.g., manual, automated pricing). Should be 1 character in length.
     * - use: optional
     * @var string
     */
    public $FareCalcMode;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Used to specify net or sell amount.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The ReportingCode
     * Meta information extracted from the WSDL
     * - documentation: A secondary identifier reflecting the method of pricing for this transaction used in the reporting process.
     * - use: optional
     * @var string
     */
    public $ReportingCode;
    /**
     * Constructor method for UnstructuredFareCalc
     * @uses UnstructuredFareCalc::setInfo()
     * @uses UnstructuredFareCalc::set_()
     * @uses UnstructuredFareCalc::setFareCalcMode()
     * @uses UnstructuredFareCalc::setOperation()
     * @uses UnstructuredFareCalc::setType()
     * @uses UnstructuredFareCalc::setReportingCode()
     * @param string $info
     * @param string $_
     * @param string $fareCalcMode
     * @param string $operation
     * @param string $type
     * @param string $reportingCode
     */
    public function __construct($info = null, $_ = null, $fareCalcMode = null, $operation = null, $type = null, $reportingCode = null)
    {
        $this
            ->setInfo($info)
            ->set_($_)
            ->setFareCalcMode($fareCalcMode)
            ->setOperation($operation)
            ->setType($type)
            ->setReportingCode($reportingCode);
    }
    /**
     * Get Info value
     * @return string
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\UnstructuredFareCalc
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\UnstructuredFareCalc
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get FareCalcMode value
     * @return string|null
     */
    public function getFareCalcMode()
    {
        return $this->FareCalcMode;
    }
    /**
     * Set FareCalcMode value
     * @param string $fareCalcMode
     * @return \StructType\UnstructuredFareCalc
     */
    public function setFareCalcMode($fareCalcMode = null)
    {
        // validation for constraint: string
        if (!is_null($fareCalcMode) && !is_string($fareCalcMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareCalcMode, true), gettype($fareCalcMode)), __LINE__);
        }
        $this->FareCalcMode = $fareCalcMode;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\UnstructuredFareCalc
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\PurposeType::valueIsValid()
     * @uses \EnumType\PurposeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\UnstructuredFareCalc
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PurposeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PurposeType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\PurposeType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ReportingCode value
     * @return string|null
     */
    public function getReportingCode()
    {
        return $this->ReportingCode;
    }
    /**
     * Set ReportingCode value
     * @param string $reportingCode
     * @return \StructType\UnstructuredFareCalc
     */
    public function setReportingCode($reportingCode = null)
    {
        // validation for constraint: string
        if (!is_null($reportingCode) && !is_string($reportingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingCode, true), gettype($reportingCode)), __LINE__);
        }
        $this->ReportingCode = $reportingCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnstructuredFareCalc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
