<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueID_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: The unique ID type. Select a value from the list or use the "Other_" value and the @extension to define a value known between trading partners. | An identifier used to uniquely reference an object in a system (e.g. an airline
 * reservation reference, customer profile reference, booking confirmation number, or a reference to a previous availability quote).
 * @subpackage Structs
 */
class UniqueID_Type extends \EnumType\Enum_UniqueIDType
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: Identifies the company that is associated with the UniqueID.
     * - minOccurs: 0
     * @var mixed
     */
    public $CompanyName;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The extension
     * Meta information extracted from the WSDL
     * - documentation: It is strongly recommended that you submit a comment to have any of your extended list values permanently added to the OpenTravel specification to support maximum trading partner interoperability.
     * http://www.opentraveldevelopersnetwork.com/specificationcomments/2/entercomment.html | A string value that represents an "Other_", or extended, enumerated value agreed upon between trading partners.
     * - use: optional
     * @var string
     */
    public $extension;
    /**
     * The ID_Context
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the source of the identifier. | Used to identify the source of the identifier (e.g., IATA, ABTA).
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $ID_Context;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: URL that identifies the location associated with the record identified by the UniqueID.
     * - type: xs:anyURI
     * - use: optional
     * @var string
     */
    public $URL;
    /**
     * Constructor method for UniqueID_Type
     * @uses UniqueID_Type::setCompanyName()
     * @uses UniqueID_Type::setTPA_Extensions()
     * @uses UniqueID_Type::setExtension()
     * @uses UniqueID_Type::setID_Context()
     * @uses UniqueID_Type::setURL()
     * @param mixed $companyName
     * @param mixed $tPA_Extensions
     * @param string $extension
     * @param string $iD_Context
     * @param string $uRL
     */
    public function __construct($companyName = null, $tPA_Extensions = null, $extension = null, $iD_Context = null, $uRL = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setTPA_Extensions($tPA_Extensions)
            ->setExtension($extension)
            ->setID_Context($iD_Context)
            ->setURL($uRL);
    }
    /**
     * Get CompanyName value
     * @return mixed|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param mixed $companyName
     * @return \StructType\UniqueID_Type
     */
    public function setCompanyName($companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\UniqueID_Type
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return \StructType\UniqueID_Type
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get ID_Context value
     * @return string|null
     */
    public function getID_Context()
    {
        return $this->ID_Context;
    }
    /**
     * Set ID_Context value
     * @param string $iD_Context
     * @return \StructType\UniqueID_Type
     */
    public function setID_Context($iD_Context = null)
    {
        // validation for constraint: string
        if (!is_null($iD_Context) && !is_string($iD_Context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD_Context, true), gettype($iD_Context)), __LINE__);
        }
        $this->ID_Context = $iD_Context;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\UniqueID_Type
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UniqueID_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
