<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueID StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to convey the identity of the profile, the owner of the profile, or an id provided by the client.
 * - type: xs:string
 * - use: optional
 * @subpackage Structs
 */
class UniqueID extends UniqueID_Type
{
    /**
     * The PinNumber
     * Meta information extracted from the WSDL
     * - documentation: The personal identification number (password) for this ID. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PinNumber;
    /**
     * Constructor method for UniqueID
     * @uses UniqueID::setPinNumber()
     * @param string $pinNumber
     */
    public function __construct($pinNumber = null)
    {
        $this
            ->setPinNumber($pinNumber);
    }
    /**
     * Get PinNumber value
     * @return string|null
     */
    public function getPinNumber()
    {
        return $this->PinNumber;
    }
    /**
     * Set PinNumber value
     * @param string $pinNumber
     * @return \StructType\UniqueID
     */
    public function setPinNumber($pinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pinNumber) && !is_string($pinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pinNumber, true), gettype($pinNumber)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pinNumber) && mb_strlen($pinNumber) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pinNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pinNumber) && mb_strlen($pinNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pinNumber)), __LINE__);
        }
        $this->PinNumber = $pinNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UniqueID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
