<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for URLsType StructType
 * Meta information extracted from the WSDL
 * - documentation: The URLs class identifies URI information.
 * @subpackage Structs
 */
class URLsType extends AbstractStructBase
{
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\URL[]
     */
    public $URL;
    /**
     * Constructor method for URLsType
     * @uses URLsType::setURL()
     * @param \StructType\URL[] $uRL
     */
    public function __construct(array $uRL = array())
    {
        $this
            ->setURL($uRL);
    }
    /**
     * Get URL value
     * @return \StructType\URL[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uRLsTypeURLItem) {
            // validation for constraint: itemType
            if (!$uRLsTypeURLItem instanceof \StructType\URL) {
                $invalidValues[] = is_object($uRLsTypeURLItem) ? get_class($uRLsTypeURLItem) : sprintf('%s(%s)', gettype($uRLsTypeURLItem), var_export($uRLsTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type \StructType\URL, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \StructType\URL[] $uRL
     * @return \StructType\URLsType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \StructType\URL $item
     * @return \StructType\URLsType
     */
    public function addToURL(\StructType\URL $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\URL) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type \StructType\URL, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\URLsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
