<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripInsurance StructType
 * Meta information extracted from the WSDL
 * - documentation: The starting and ending date and time for the insurance coverage. | Trip insurance offer information.
 * @subpackage Structs
 */
class TripInsurance extends AbstractStructBase
{
    /**
     * The CoveredTraveler
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\CoveredTraveler[]
     */
    public $CoveredTraveler;
    /**
     * The CoverageLimit
     * Meta information extracted from the WSDL
     * - documentation: Coverage limitations, including deductible and policy limit.
     * - minOccurs: 0
     * @var mixed
     */
    public $CoverageLimit;
    /**
     * The PlanCost
     * Meta information extracted from the WSDL
     * - documentation: Plan costs.
     * - minOccurs: 0
     * @var mixed
     */
    public $PlanCost;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The third-party insurance product code.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The SellingComponentCode
     * Meta information extracted from the WSDL
     * - documentation: The internal airline selling component code.
     * - use: optional
     * @var string
     */
    public $SellingComponentCode;
    /**
     * Constructor method for TripInsurance
     * @uses TripInsurance::setCoveredTraveler()
     * @uses TripInsurance::setCoverageLimit()
     * @uses TripInsurance::setPlanCost()
     * @uses TripInsurance::setCode()
     * @uses TripInsurance::setSellingComponentCode()
     * @param \StructType\CoveredTraveler[] $coveredTraveler
     * @param mixed $coverageLimit
     * @param mixed $planCost
     * @param string $code
     * @param string $sellingComponentCode
     */
    public function __construct(array $coveredTraveler = array(), $coverageLimit = null, $planCost = null, $code = null, $sellingComponentCode = null)
    {
        $this
            ->setCoveredTraveler($coveredTraveler)
            ->setCoverageLimit($coverageLimit)
            ->setPlanCost($planCost)
            ->setCode($code)
            ->setSellingComponentCode($sellingComponentCode);
    }
    /**
     * Get CoveredTraveler value
     * @return \StructType\CoveredTraveler[]|null
     */
    public function getCoveredTraveler()
    {
        return $this->CoveredTraveler;
    }
    /**
     * This method is responsible for validating the values passed to the setCoveredTraveler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoveredTraveler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoveredTravelerForArrayConstraintsFromSetCoveredTraveler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tripInsuranceCoveredTravelerItem) {
            // validation for constraint: itemType
            if (!$tripInsuranceCoveredTravelerItem instanceof \StructType\CoveredTraveler) {
                $invalidValues[] = is_object($tripInsuranceCoveredTravelerItem) ? get_class($tripInsuranceCoveredTravelerItem) : sprintf('%s(%s)', gettype($tripInsuranceCoveredTravelerItem), var_export($tripInsuranceCoveredTravelerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CoveredTraveler property can only contain items of type \StructType\CoveredTraveler, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CoveredTraveler value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveredTraveler[] $coveredTraveler
     * @return \StructType\TripInsurance
     */
    public function setCoveredTraveler(array $coveredTraveler = array())
    {
        // validation for constraint: array
        if ('' !== ($coveredTravelerArrayErrorMessage = self::validateCoveredTravelerForArrayConstraintsFromSetCoveredTraveler($coveredTraveler))) {
            throw new \InvalidArgumentException($coveredTravelerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($coveredTraveler) && count($coveredTraveler) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($coveredTraveler)), __LINE__);
        }
        $this->CoveredTraveler = $coveredTraveler;
        return $this;
    }
    /**
     * Add item to CoveredTraveler value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveredTraveler $item
     * @return \StructType\TripInsurance
     */
    public function addToCoveredTraveler(\StructType\CoveredTraveler $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoveredTraveler) {
            throw new \InvalidArgumentException(sprintf('The CoveredTraveler property can only contain items of type \StructType\CoveredTraveler, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->CoveredTraveler) && count($this->CoveredTraveler) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->CoveredTraveler)), __LINE__);
        }
        $this->CoveredTraveler[] = $item;
        return $this;
    }
    /**
     * Get CoverageLimit value
     * @return mixed|null
     */
    public function getCoverageLimit()
    {
        return $this->CoverageLimit;
    }
    /**
     * Set CoverageLimit value
     * @param mixed $coverageLimit
     * @return \StructType\TripInsurance
     */
    public function setCoverageLimit($coverageLimit = null)
    {
        $this->CoverageLimit = $coverageLimit;
        return $this;
    }
    /**
     * Get PlanCost value
     * @return mixed|null
     */
    public function getPlanCost()
    {
        return $this->PlanCost;
    }
    /**
     * Set PlanCost value
     * @param mixed $planCost
     * @return \StructType\TripInsurance
     */
    public function setPlanCost($planCost = null)
    {
        $this->PlanCost = $planCost;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\TripInsurance
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get SellingComponentCode value
     * @return string|null
     */
    public function getSellingComponentCode()
    {
        return $this->SellingComponentCode;
    }
    /**
     * Set SellingComponentCode value
     * @param string $sellingComponentCode
     * @return \StructType\TripInsurance
     */
    public function setSellingComponentCode($sellingComponentCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellingComponentCode) && !is_string($sellingComponentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellingComponentCode, true), gettype($sellingComponentCode)), __LINE__);
        }
        $this->SellingComponentCode = $sellingComponentCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
