<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerRefNumber StructType
 * Meta information extracted from the WSDL
 * - documentation: One or more travelers to whom this request applies. | Contains the RPH reference to the traveler. | Direct reference of traveler assigned by requesting system. Used as a cross reference between data segments. | One or more travelers
 * to whom this request applies
 * @subpackage Structs
 */
class TravelerRefNumber extends AbstractStructBase
{
    /**
     * The RangePosition
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RangePosition;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique reference for the traveler.
     * - type: RPH_Type
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The SurnameRefNumber
     * Meta information extracted from the WSDL
     * - documentation: Used to identify and associate travelers with the same surname.
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $SurnameRefNumber;
    /**
     * Constructor method for TravelerRefNumber
     * @uses TravelerRefNumber::setRangePosition()
     * @uses TravelerRefNumber::setRPH()
     * @uses TravelerRefNumber::setSurnameRefNumber()
     * @param string $rangePosition
     * @param string $rPH
     * @param string $surnameRefNumber
     */
    public function __construct($rangePosition = null, $rPH = null, $surnameRefNumber = null)
    {
        $this
            ->setRangePosition($rangePosition)
            ->setRPH($rPH)
            ->setSurnameRefNumber($surnameRefNumber);
    }
    /**
     * Get RangePosition value
     * @return string|null
     */
    public function getRangePosition()
    {
        return $this->RangePosition;
    }
    /**
     * Set RangePosition value
     * @param string $rangePosition
     * @return \StructType\TravelerRefNumber
     */
    public function setRangePosition($rangePosition = null)
    {
        // validation for constraint: string
        if (!is_null($rangePosition) && !is_string($rangePosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rangePosition, true), gettype($rangePosition)), __LINE__);
        }
        $this->RangePosition = $rangePosition;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\TravelerRefNumber
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get SurnameRefNumber value
     * @return string|null
     */
    public function getSurnameRefNumber()
    {
        return $this->SurnameRefNumber;
    }
    /**
     * Set SurnameRefNumber value
     * @param string $surnameRefNumber
     * @return \StructType\TravelerRefNumber
     */
    public function setSurnameRefNumber($surnameRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($surnameRefNumber) && !is_string($surnameRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surnameRefNumber, true), gettype($surnameRefNumber)), __LINE__);
        }
        $this->SurnameRefNumber = $surnameRefNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelerRefNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
