<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify passenger numbers and types.
 * @subpackage Structs
 */
class TravelerInformationType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta information extracted from the WSDL
     * - documentation: Specify number of passengers using Passenger Type Codes.
     * - maxOccurs: 10
     * @var mixed[]
     */
    public $PassengerTypeQuantity;
    /**
     * The AirTraveler
     * Meta information extracted from the WSDL
     * - documentation: Information profiling the person traveling: Gender - the gender of the customer, if needed; BirthDate - Date of Birth; Currency - the preferred currency in which monetary amounts should be returned.
     * - minOccurs: 0
     * @var mixed
     */
    public $AirTraveler;
    /**
     * Constructor method for TravelerInformationType
     * @uses TravelerInformationType::setPassengerTypeQuantity()
     * @uses TravelerInformationType::setAirTraveler()
     * @param mixed[] $passengerTypeQuantity
     * @param mixed $airTraveler
     */
    public function __construct(array $passengerTypeQuantity = array(), $airTraveler = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setAirTraveler($airTraveler);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return mixed[]|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerTypeQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerTypeQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerTypeQuantityForArrayConstraintsFromSetPassengerTypeQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelerInformationTypePassengerTypeQuantityItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($travelerInformationTypePassengerTypeQuantityItem) ? get_class($travelerInformationTypePassengerTypeQuantityItem) : sprintf('%s(%s)', gettype($travelerInformationTypePassengerTypeQuantityItem), var_export($travelerInformationTypePassengerTypeQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerTypeQuantity property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param mixed[] $passengerTypeQuantity
     * @return \StructType\TravelerInformationType
     */
    public function setPassengerTypeQuantity(array $passengerTypeQuantity = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerTypeQuantityArrayErrorMessage = self::validatePassengerTypeQuantityForArrayConstraintsFromSetPassengerTypeQuantity($passengerTypeQuantity))) {
            throw new \InvalidArgumentException($passengerTypeQuantityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($passengerTypeQuantity) && count($passengerTypeQuantity) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($passengerTypeQuantity)), __LINE__);
        }
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Add item to PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\TravelerInformationType
     */
    public function addToPassengerTypeQuantity($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PassengerTypeQuantity property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->PassengerTypeQuantity) && count($this->PassengerTypeQuantity) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->PassengerTypeQuantity)), __LINE__);
        }
        $this->PassengerTypeQuantity[] = $item;
        return $this;
    }
    /**
     * Get AirTraveler value
     * @return mixed|null
     */
    public function getAirTraveler()
    {
        return $this->AirTraveler;
    }
    /**
     * Set AirTraveler value
     * @param mixed $airTraveler
     * @return \StructType\TravelerInformationType
     */
    public function setAirTraveler($airTraveler = null)
    {
        $this->AirTraveler = $airTraveler;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelerInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
