<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerCharacteristics StructType
 * Meta information extracted from the WSDL
 * - documentation: Traveler characteristics.
 * @subpackage Structs
 */
class TravelerCharacteristics extends AbstractStructBase
{
    /**
     * The TripPurpose
     * Meta information extracted from the WSDL
     * - documentation: Trip purpose.
     * - minOccurs: 0
     * @var mixed
     */
    public $TripPurpose;
    /**
     * The Classification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Classification
     */
    public $Classification;
    /**
     * The DetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DetailInfo[]
     */
    public $DetailInfo;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for TravelerCharacteristics
     * @uses TravelerCharacteristics::setTripPurpose()
     * @uses TravelerCharacteristics::setClassification()
     * @uses TravelerCharacteristics::setDetailInfo()
     * @uses TravelerCharacteristics::setOntologyExtension()
     * @param mixed $tripPurpose
     * @param \StructType\Classification $classification
     * @param \StructType\DetailInfo[] $detailInfo
     * @param mixed $ontologyExtension
     */
    public function __construct($tripPurpose = null, \StructType\Classification $classification = null, array $detailInfo = array(), $ontologyExtension = null)
    {
        $this
            ->setTripPurpose($tripPurpose)
            ->setClassification($classification)
            ->setDetailInfo($detailInfo)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get TripPurpose value
     * @return mixed|null
     */
    public function getTripPurpose()
    {
        return $this->TripPurpose;
    }
    /**
     * Set TripPurpose value
     * @param mixed $tripPurpose
     * @return \StructType\TravelerCharacteristics
     */
    public function setTripPurpose($tripPurpose = null)
    {
        $this->TripPurpose = $tripPurpose;
        return $this;
    }
    /**
     * Get Classification value
     * @return \StructType\Classification|null
     */
    public function getClassification()
    {
        return $this->Classification;
    }
    /**
     * Set Classification value
     * @param \StructType\Classification $classification
     * @return \StructType\TravelerCharacteristics
     */
    public function setClassification(\StructType\Classification $classification = null)
    {
        $this->Classification = $classification;
        return $this;
    }
    /**
     * Get DetailInfo value
     * @return \StructType\DetailInfo[]|null
     */
    public function getDetailInfo()
    {
        return $this->DetailInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setDetailInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetailInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailInfoForArrayConstraintsFromSetDetailInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelerCharacteristicsDetailInfoItem) {
            // validation for constraint: itemType
            if (!$travelerCharacteristicsDetailInfoItem instanceof \StructType\DetailInfo) {
                $invalidValues[] = is_object($travelerCharacteristicsDetailInfoItem) ? get_class($travelerCharacteristicsDetailInfoItem) : sprintf('%s(%s)', gettype($travelerCharacteristicsDetailInfoItem), var_export($travelerCharacteristicsDetailInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DetailInfo property can only contain items of type \StructType\DetailInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DetailInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailInfo[] $detailInfo
     * @return \StructType\TravelerCharacteristics
     */
    public function setDetailInfo(array $detailInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($detailInfoArrayErrorMessage = self::validateDetailInfoForArrayConstraintsFromSetDetailInfo($detailInfo))) {
            throw new \InvalidArgumentException($detailInfoArrayErrorMessage, __LINE__);
        }
        $this->DetailInfo = $detailInfo;
        return $this;
    }
    /**
     * Add item to DetailInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailInfo $item
     * @return \StructType\TravelerCharacteristics
     */
    public function addToDetailInfo(\StructType\DetailInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DetailInfo) {
            throw new \InvalidArgumentException(sprintf('The DetailInfo property can only contain items of type \StructType\DetailInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DetailInfo[] = $item;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\TravelerCharacteristics
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelerCharacteristics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
