<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines information about a train segment.
 * @subpackage Structs
 */
class TrainSegmentType extends AbstractStructBase
{
    /**
     * The DepartureStation
     * Meta information extracted from the WSDL
     * - documentation: The departure point of the train segment.
     * @var mixed
     */
    public $DepartureStation;
    /**
     * The ArrivalStation
     * Meta information extracted from the WSDL
     * - documentation: The arrival point of the train segment.
     * @var mixed
     */
    public $ArrivalStation;
    /**
     * The MarketingCompany
     * Meta information extracted from the WSDL
     * - documentation: The marketing train company.
     * @var mixed
     */
    public $MarketingCompany;
    /**
     * The OperatingCompany
     * Meta information extracted from the WSDL
     * - documentation: The operating train company, if different from the Marketing Company.
     * - minOccurs: 0
     * @var mixed
     */
    public $OperatingCompany;
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - documentation: The type of equipment used for the train journey. Use a string value, such as the operator equipment code or a UIC code.
     * - minOccurs: 0
     * @var mixed
     */
    public $Equipment;
    /**
     * The TrainInfo
     * Meta information extracted from the WSDL
     * - documentation: Detailed information about the train.
     * - minOccurs: 0
     * @var mixed
     */
    public $TrainInfo;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: The departure date and time.
     * - use: optional
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: The arrival date and time.
     * - use: optional
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The StopQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of stops the train makes.
     * - use: optional
     * @var int
     */
    public $StopQuantity;
    /**
     * The JourneyDuration
     * Meta information extracted from the WSDL
     * - documentation: The duration of the train from departure location to destination location.
     * - use: optional
     * @var string
     */
    public $JourneyDuration;
    /**
     * The CrossBorderInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the train schedule includes a border crossing.
     * - use: optional
     * @var bool
     */
    public $CrossBorderInd;
    /**
     * Constructor method for TrainSegmentType
     * @uses TrainSegmentType::setDepartureStation()
     * @uses TrainSegmentType::setArrivalStation()
     * @uses TrainSegmentType::setMarketingCompany()
     * @uses TrainSegmentType::setOperatingCompany()
     * @uses TrainSegmentType::setEquipment()
     * @uses TrainSegmentType::setTrainInfo()
     * @uses TrainSegmentType::setDepartureDateTime()
     * @uses TrainSegmentType::setArrivalDateTime()
     * @uses TrainSegmentType::setStopQuantity()
     * @uses TrainSegmentType::setJourneyDuration()
     * @uses TrainSegmentType::setCrossBorderInd()
     * @param mixed $departureStation
     * @param mixed $arrivalStation
     * @param mixed $marketingCompany
     * @param mixed $operatingCompany
     * @param mixed $equipment
     * @param mixed $trainInfo
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param int $stopQuantity
     * @param string $journeyDuration
     * @param bool $crossBorderInd
     */
    public function __construct($departureStation = null, $arrivalStation = null, $marketingCompany = null, $operatingCompany = null, $equipment = null, $trainInfo = null, $departureDateTime = null, $arrivalDateTime = null, $stopQuantity = null, $journeyDuration = null, $crossBorderInd = null)
    {
        $this
            ->setDepartureStation($departureStation)
            ->setArrivalStation($arrivalStation)
            ->setMarketingCompany($marketingCompany)
            ->setOperatingCompany($operatingCompany)
            ->setEquipment($equipment)
            ->setTrainInfo($trainInfo)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setStopQuantity($stopQuantity)
            ->setJourneyDuration($journeyDuration)
            ->setCrossBorderInd($crossBorderInd);
    }
    /**
     * Get DepartureStation value
     * @return mixed|null
     */
    public function getDepartureStation()
    {
        return $this->DepartureStation;
    }
    /**
     * Set DepartureStation value
     * @param mixed $departureStation
     * @return \StructType\TrainSegmentType
     */
    public function setDepartureStation($departureStation = null)
    {
        $this->DepartureStation = $departureStation;
        return $this;
    }
    /**
     * Get ArrivalStation value
     * @return mixed|null
     */
    public function getArrivalStation()
    {
        return $this->ArrivalStation;
    }
    /**
     * Set ArrivalStation value
     * @param mixed $arrivalStation
     * @return \StructType\TrainSegmentType
     */
    public function setArrivalStation($arrivalStation = null)
    {
        $this->ArrivalStation = $arrivalStation;
        return $this;
    }
    /**
     * Get MarketingCompany value
     * @return mixed|null
     */
    public function getMarketingCompany()
    {
        return $this->MarketingCompany;
    }
    /**
     * Set MarketingCompany value
     * @param mixed $marketingCompany
     * @return \StructType\TrainSegmentType
     */
    public function setMarketingCompany($marketingCompany = null)
    {
        $this->MarketingCompany = $marketingCompany;
        return $this;
    }
    /**
     * Get OperatingCompany value
     * @return mixed|null
     */
    public function getOperatingCompany()
    {
        return $this->OperatingCompany;
    }
    /**
     * Set OperatingCompany value
     * @param mixed $operatingCompany
     * @return \StructType\TrainSegmentType
     */
    public function setOperatingCompany($operatingCompany = null)
    {
        $this->OperatingCompany = $operatingCompany;
        return $this;
    }
    /**
     * Get Equipment value
     * @return mixed|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param mixed $equipment
     * @return \StructType\TrainSegmentType
     */
    public function setEquipment($equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get TrainInfo value
     * @return mixed|null
     */
    public function getTrainInfo()
    {
        return $this->TrainInfo;
    }
    /**
     * Set TrainInfo value
     * @param mixed $trainInfo
     * @return \StructType\TrainSegmentType
     */
    public function setTrainInfo($trainInfo = null)
    {
        $this->TrainInfo = $trainInfo;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\TrainSegmentType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\TrainSegmentType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return int|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param int $stopQuantity
     * @return \StructType\TrainSegmentType
     */
    public function setStopQuantity($stopQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($stopQuantity) && !(is_int($stopQuantity) || ctype_digit($stopQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stopQuantity, true), gettype($stopQuantity)), __LINE__);
        }
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Get JourneyDuration value
     * @return string|null
     */
    public function getJourneyDuration()
    {
        return $this->JourneyDuration;
    }
    /**
     * Set JourneyDuration value
     * @param string $journeyDuration
     * @return \StructType\TrainSegmentType
     */
    public function setJourneyDuration($journeyDuration = null)
    {
        // validation for constraint: string
        if (!is_null($journeyDuration) && !is_string($journeyDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journeyDuration, true), gettype($journeyDuration)), __LINE__);
        }
        $this->JourneyDuration = $journeyDuration;
        return $this;
    }
    /**
     * Get CrossBorderInd value
     * @return bool|null
     */
    public function getCrossBorderInd()
    {
        return $this->CrossBorderInd;
    }
    /**
     * Set CrossBorderInd value
     * @param bool $crossBorderInd
     * @return \StructType\TrainSegmentType
     */
    public function setCrossBorderInd($crossBorderInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($crossBorderInd) && !is_bool($crossBorderInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($crossBorderInd, true), gettype($crossBorderInd)), __LINE__);
        }
        $this->CrossBorderInd = $crossBorderInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrainSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
