<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainSegment StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines train segment summary information, including departure and arrival stations, departure and arrival dates/times, and train identification information. | A collection of train segments that provide journey information from
 * origin to destination. Each segment has full details on one specific train segment, including the origin and destination locations for this segment, the requested class of service, and the operating company, if appropriate.
 * @subpackage Structs
 */
class TrainSegment extends AbstractStructBase
{
    /**
     * The DepartureStation
     * Meta information extracted from the WSDL
     * - documentation: Train departure station location.
     * @var mixed
     */
    public $DepartureStation;
    /**
     * The ArrivalStation
     * Meta information extracted from the WSDL
     * - documentation: Train arrival station location.
     * @var mixed
     */
    public $ArrivalStation;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: The departure date and time.
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: The arrival date and time.
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The TrainIdentification
     * Meta information extracted from the WSDL
     * - documentation: Train identification information, including a train type code, a train number and a train network code.
     * @var mixed
     */
    public $TrainIdentification;
    /**
     * Constructor method for TrainSegment
     * @uses TrainSegment::setDepartureStation()
     * @uses TrainSegment::setArrivalStation()
     * @uses TrainSegment::setDepartureDateTime()
     * @uses TrainSegment::setArrivalDateTime()
     * @uses TrainSegment::setTrainIdentification()
     * @param mixed $departureStation
     * @param mixed $arrivalStation
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param mixed $trainIdentification
     */
    public function __construct($departureStation = null, $arrivalStation = null, $departureDateTime = null, $arrivalDateTime = null, $trainIdentification = null)
    {
        $this
            ->setDepartureStation($departureStation)
            ->setArrivalStation($arrivalStation)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setTrainIdentification($trainIdentification);
    }
    /**
     * Get DepartureStation value
     * @return mixed|null
     */
    public function getDepartureStation()
    {
        return $this->DepartureStation;
    }
    /**
     * Set DepartureStation value
     * @param mixed $departureStation
     * @return \StructType\TrainSegment
     */
    public function setDepartureStation($departureStation = null)
    {
        $this->DepartureStation = $departureStation;
        return $this;
    }
    /**
     * Get ArrivalStation value
     * @return mixed|null
     */
    public function getArrivalStation()
    {
        return $this->ArrivalStation;
    }
    /**
     * Set ArrivalStation value
     * @param mixed $arrivalStation
     * @return \StructType\TrainSegment
     */
    public function setArrivalStation($arrivalStation = null)
    {
        $this->ArrivalStation = $arrivalStation;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\TrainSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\TrainSegment
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get TrainIdentification value
     * @return mixed|null
     */
    public function getTrainIdentification()
    {
        return $this->TrainIdentification;
    }
    /**
     * Set TrainIdentification value
     * @param mixed $trainIdentification
     * @return \StructType\TrainSegment
     */
    public function setTrainIdentification($trainIdentification = null)
    {
        $this->TrainIdentification = $trainIdentification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrainSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
