<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainQueryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines information to do a query by train operator or specific train information.
 * @subpackage Structs
 */
class TrainQueryType extends AbstractStructBase
{
    /**
     * The Train
     * Meta information extracted from the WSDL
     * - documentation: A specific train and network code.
     * - choice: Train | NetworkCode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $Train;
    /**
     * The NetworkCode
     * Meta information extracted from the WSDL
     * - documentation: The network code of a rail operator defined by International Union of Railways (UIC.)
     * - choice: Train | NetworkCode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $NetworkCode;
    /**
     * Constructor method for TrainQueryType
     * @uses TrainQueryType::setTrain()
     * @uses TrainQueryType::setNetworkCode()
     * @param mixed $train
     * @param mixed $networkCode
     */
    public function __construct($train = null, $networkCode = null)
    {
        $this
            ->setTrain($train)
            ->setNetworkCode($networkCode);
    }
    /**
     * Get Train value
     * @return mixed|null
     */
    public function getTrain()
    {
        return isset($this->Train) ? $this->Train : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTrain method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrain method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTrainForChoiceConstraintsFromSetTrain($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NetworkCode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Train can\'t be set as the property %s is already set. Only one property must be set among these properties: Train, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Train value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $train
     * @return \StructType\TrainQueryType
     */
    public function setTrain($train = null)
    {
        // validation for constraint: choice(Train, NetworkCode)
        if ('' !== ($trainChoiceErrorMessage = self::validateTrainForChoiceConstraintsFromSetTrain($train))) {
            throw new \InvalidArgumentException($trainChoiceErrorMessage, __LINE__);
        }
        if (is_null($train) || (is_array($train) && empty($train))) {
            unset($this->Train);
        } else {
            $this->Train = $train;
        }
        return $this;
    }
    /**
     * Get NetworkCode value
     * @return mixed|null
     */
    public function getNetworkCode()
    {
        return isset($this->NetworkCode) ? $this->NetworkCode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNetworkCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNetworkCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNetworkCodeForChoiceConstraintsFromSetNetworkCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Train',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NetworkCode can\'t be set as the property %s is already set. Only one property must be set among these properties: NetworkCode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NetworkCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $networkCode
     * @return \StructType\TrainQueryType
     */
    public function setNetworkCode($networkCode = null)
    {
        // validation for constraint: choice(Train, NetworkCode)
        if ('' !== ($networkCodeChoiceErrorMessage = self::validateNetworkCodeForChoiceConstraintsFromSetNetworkCode($networkCode))) {
            throw new \InvalidArgumentException($networkCodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($networkCode) || (is_array($networkCode) && empty($networkCode))) {
            unset($this->NetworkCode);
        } else {
            $this->NetworkCode = $networkCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrainQueryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
