<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalConstructionAmount StructType
 * Meta information extracted from the WSDL
 * - documentation: The total construction amount and the applicable currency code. | The total base, total net, or total sell construction amount.
 * @subpackage Structs
 */
class TotalConstructionAmount extends AbstractStructBase
{
    /**
     * The Purpose
     * Meta information extracted from the WSDL
     * - documentation: Used to specify base, base net, or base sell.
     * - use: required
     * @var string
     */
    public $Purpose;
    /**
     * Constructor method for TotalConstructionAmount
     * @uses TotalConstructionAmount::setPurpose()
     * @param string $purpose
     */
    public function __construct($purpose = null)
    {
        $this
            ->setPurpose($purpose);
    }
    /**
     * Get Purpose value
     * @return string
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @uses \EnumType\PurposeType::valueIsValid()
     * @uses \EnumType\PurposeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $purpose
     * @return \StructType\TotalConstructionAmount
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PurposeType::valueIsValid($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PurposeType', is_array($purpose) ? implode(', ', $purpose) : var_export($purpose, true), implode(', ', \EnumType\PurposeType::getValidValues())), __LINE__);
        }
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TotalConstructionAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
