<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimePeriod StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer starting date/ time period and time period duration.
 * @subpackage Structs
 */
class TimePeriod extends AbstractStructBase
{
    /**
     * The EarliestStart
     * @var \StructType\EarliestStart
     */
    public $EarliestStart;
    /**
     * The MaximumDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MaximumDuration
     */
    public $MaximumDuration;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for TimePeriod
     * @uses TimePeriod::setEarliestStart()
     * @uses TimePeriod::setMaximumDuration()
     * @uses TimePeriod::setOntologyExtension()
     * @uses TimePeriod::setOntologyRefID()
     * @param \StructType\EarliestStart $earliestStart
     * @param \StructType\MaximumDuration $maximumDuration
     * @param mixed $ontologyExtension
     * @param string $ontologyRefID
     */
    public function __construct(\StructType\EarliestStart $earliestStart = null, \StructType\MaximumDuration $maximumDuration = null, $ontologyExtension = null, $ontologyRefID = null)
    {
        $this
            ->setEarliestStart($earliestStart)
            ->setMaximumDuration($maximumDuration)
            ->setOntologyExtension($ontologyExtension)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get EarliestStart value
     * @return \StructType\EarliestStart|null
     */
    public function getEarliestStart()
    {
        return $this->EarliestStart;
    }
    /**
     * Set EarliestStart value
     * @param \StructType\EarliestStart $earliestStart
     * @return \StructType\TimePeriod
     */
    public function setEarliestStart(\StructType\EarliestStart $earliestStart = null)
    {
        $this->EarliestStart = $earliestStart;
        return $this;
    }
    /**
     * Get MaximumDuration value
     * @return \StructType\MaximumDuration|null
     */
    public function getMaximumDuration()
    {
        return $this->MaximumDuration;
    }
    /**
     * Set MaximumDuration value
     * @param \StructType\MaximumDuration $maximumDuration
     * @return \StructType\TimePeriod
     */
    public function setMaximumDuration(\StructType\MaximumDuration $maximumDuration = null)
    {
        $this->MaximumDuration = $maximumDuration;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\TimePeriod
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\TimePeriod
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TimePeriod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
