<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDocument StructType
 * Meta information extracted from the WSDL
 * - documentation: The ticket/document number to which the tax coupon data applies. | The two/three character designator representing the carrier whose fee was used on the EMD coupons. | The EMD type, in connection number, fee owner and date of issue.
 * @subpackage Structs
 */
class TicketDocument extends AbstractStructBase
{
    /**
     * The TicketDocumentNbr
     * Meta information extracted from the WSDL
     * - documentation: The ticket/document number for this transaction. | Document number comprised of the airline code, form code, and serial number.
     * - use: required
     * @var string
     */
    public $TicketDocumentNbr;
    /**
     * The CouponInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * @var \StructType\CouponInfo[]
     */
    public $CouponInfo;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The PrimaryDocInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this is the primary ticket/document number.
     * - use: optional
     * @var bool
     */
    public $PrimaryDocInd;
    /**
     * The InConnectionDocNbr
     * Meta information extracted from the WSDL
     * - documentation: The ticket/document number of another ticket to which this ticket is connected.
     * - use: optional
     * @var string
     */
    public $InConnectionDocNbr;
    /**
     * The DateOfIssue
     * Meta information extracted from the WSDL
     * - documentation: The date a document was issued.
     * - use: optional
     * @var string
     */
    public $DateOfIssue;
    /**
     * The ExchangeTktNbrInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this is the new ticket number for a ticket that is being exchanged.
     * - use: optional
     * @var bool
     */
    public $ExchangeTktNbrInd;
    /**
     * The CouponNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * @var \StructType\CouponNumber[]
     */
    public $CouponNumber;
    /**
     * Constructor method for TicketDocument
     * @uses TicketDocument::setTicketDocumentNbr()
     * @uses TicketDocument::setCouponInfo()
     * @uses TicketDocument::setType()
     * @uses TicketDocument::setPrimaryDocInd()
     * @uses TicketDocument::setInConnectionDocNbr()
     * @uses TicketDocument::setDateOfIssue()
     * @uses TicketDocument::setExchangeTktNbrInd()
     * @uses TicketDocument::setCouponNumber()
     * @param string $ticketDocumentNbr
     * @param \StructType\CouponInfo[] $couponInfo
     * @param string $type
     * @param bool $primaryDocInd
     * @param string $inConnectionDocNbr
     * @param string $dateOfIssue
     * @param bool $exchangeTktNbrInd
     * @param \StructType\CouponNumber[] $couponNumber
     */
    public function __construct($ticketDocumentNbr = null, array $couponInfo = array(), $type = null, $primaryDocInd = null, $inConnectionDocNbr = null, $dateOfIssue = null, $exchangeTktNbrInd = null, array $couponNumber = array())
    {
        $this
            ->setTicketDocumentNbr($ticketDocumentNbr)
            ->setCouponInfo($couponInfo)
            ->setType($type)
            ->setPrimaryDocInd($primaryDocInd)
            ->setInConnectionDocNbr($inConnectionDocNbr)
            ->setDateOfIssue($dateOfIssue)
            ->setExchangeTktNbrInd($exchangeTktNbrInd)
            ->setCouponNumber($couponNumber);
    }
    /**
     * Get TicketDocumentNbr value
     * @return string
     */
    public function getTicketDocumentNbr()
    {
        return $this->TicketDocumentNbr;
    }
    /**
     * Set TicketDocumentNbr value
     * @param string $ticketDocumentNbr
     * @return \StructType\TicketDocument
     */
    public function setTicketDocumentNbr($ticketDocumentNbr = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocumentNbr) && !is_string($ticketDocumentNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocumentNbr, true), gettype($ticketDocumentNbr)), __LINE__);
        }
        $this->TicketDocumentNbr = $ticketDocumentNbr;
        return $this;
    }
    /**
     * Get CouponInfo value
     * @return \StructType\CouponInfo[]|null
     */
    public function getCouponInfo()
    {
        return $this->CouponInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCouponInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCouponInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponInfoForArrayConstraintsFromSetCouponInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocumentCouponInfoItem) {
            // validation for constraint: itemType
            if (!$ticketDocumentCouponInfoItem instanceof \StructType\CouponInfo) {
                $invalidValues[] = is_object($ticketDocumentCouponInfoItem) ? get_class($ticketDocumentCouponInfoItem) : sprintf('%s(%s)', gettype($ticketDocumentCouponInfoItem), var_export($ticketDocumentCouponInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CouponInfo property can only contain items of type \StructType\CouponInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CouponInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponInfo[] $couponInfo
     * @return \StructType\TicketDocument
     */
    public function setCouponInfo(array $couponInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($couponInfoArrayErrorMessage = self::validateCouponInfoForArrayConstraintsFromSetCouponInfo($couponInfo))) {
            throw new \InvalidArgumentException($couponInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($couponInfo) && count($couponInfo) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($couponInfo)), __LINE__);
        }
        $this->CouponInfo = $couponInfo;
        return $this;
    }
    /**
     * Add item to CouponInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponInfo $item
     * @return \StructType\TicketDocument
     */
    public function addToCouponInfo(\StructType\CouponInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CouponInfo) {
            throw new \InvalidArgumentException(sprintf('The CouponInfo property can only contain items of type \StructType\CouponInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->CouponInfo) && count($this->CouponInfo) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->CouponInfo)), __LINE__);
        }
        $this->CouponInfo[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\TicketDocument
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PrimaryDocInd value
     * @return bool|null
     */
    public function getPrimaryDocInd()
    {
        return $this->PrimaryDocInd;
    }
    /**
     * Set PrimaryDocInd value
     * @param bool $primaryDocInd
     * @return \StructType\TicketDocument
     */
    public function setPrimaryDocInd($primaryDocInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryDocInd) && !is_bool($primaryDocInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryDocInd, true), gettype($primaryDocInd)), __LINE__);
        }
        $this->PrimaryDocInd = $primaryDocInd;
        return $this;
    }
    /**
     * Get InConnectionDocNbr value
     * @return string|null
     */
    public function getInConnectionDocNbr()
    {
        return $this->InConnectionDocNbr;
    }
    /**
     * Set InConnectionDocNbr value
     * @param string $inConnectionDocNbr
     * @return \StructType\TicketDocument
     */
    public function setInConnectionDocNbr($inConnectionDocNbr = null)
    {
        // validation for constraint: string
        if (!is_null($inConnectionDocNbr) && !is_string($inConnectionDocNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inConnectionDocNbr, true), gettype($inConnectionDocNbr)), __LINE__);
        }
        $this->InConnectionDocNbr = $inConnectionDocNbr;
        return $this;
    }
    /**
     * Get DateOfIssue value
     * @return string|null
     */
    public function getDateOfIssue()
    {
        return $this->DateOfIssue;
    }
    /**
     * Set DateOfIssue value
     * @param string $dateOfIssue
     * @return \StructType\TicketDocument
     */
    public function setDateOfIssue($dateOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfIssue) && !is_string($dateOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfIssue, true), gettype($dateOfIssue)), __LINE__);
        }
        $this->DateOfIssue = $dateOfIssue;
        return $this;
    }
    /**
     * Get ExchangeTktNbrInd value
     * @return bool|null
     */
    public function getExchangeTktNbrInd()
    {
        return $this->ExchangeTktNbrInd;
    }
    /**
     * Set ExchangeTktNbrInd value
     * @param bool $exchangeTktNbrInd
     * @return \StructType\TicketDocument
     */
    public function setExchangeTktNbrInd($exchangeTktNbrInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($exchangeTktNbrInd) && !is_bool($exchangeTktNbrInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exchangeTktNbrInd, true), gettype($exchangeTktNbrInd)), __LINE__);
        }
        $this->ExchangeTktNbrInd = $exchangeTktNbrInd;
        return $this;
    }
    /**
     * Get CouponNumber value
     * @return \StructType\CouponNumber[]|null
     */
    public function getCouponNumber()
    {
        return $this->CouponNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setCouponNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCouponNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponNumberForArrayConstraintsFromSetCouponNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocumentCouponNumberItem) {
            // validation for constraint: itemType
            if (!$ticketDocumentCouponNumberItem instanceof \StructType\CouponNumber) {
                $invalidValues[] = is_object($ticketDocumentCouponNumberItem) ? get_class($ticketDocumentCouponNumberItem) : sprintf('%s(%s)', gettype($ticketDocumentCouponNumberItem), var_export($ticketDocumentCouponNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CouponNumber property can only contain items of type \StructType\CouponNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CouponNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponNumber[] $couponNumber
     * @return \StructType\TicketDocument
     */
    public function setCouponNumber(array $couponNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($couponNumberArrayErrorMessage = self::validateCouponNumberForArrayConstraintsFromSetCouponNumber($couponNumber))) {
            throw new \InvalidArgumentException($couponNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($couponNumber) && count($couponNumber) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($couponNumber)), __LINE__);
        }
        $this->CouponNumber = $couponNumber;
        return $this;
    }
    /**
     * Add item to CouponNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponNumber $item
     * @return \StructType\TicketDocument
     */
    public function addToCouponNumber(\StructType\CouponNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CouponNumber) {
            throw new \InvalidArgumentException(sprintf('The CouponNumber property can only contain items of type \StructType\CouponNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->CouponNumber) && count($this->CouponNumber) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->CouponNumber)), __LINE__);
        }
        $this->CouponNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
