<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDesignators StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a collection of ticket designator elements.
 * @subpackage Structs
 */
class TicketDesignators extends AbstractStructBase
{
    /**
     * The TicketDesignator
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\TicketDesignator[]
     */
    public $TicketDesignator;
    /**
     * Constructor method for TicketDesignators
     * @uses TicketDesignators::setTicketDesignator()
     * @param \StructType\TicketDesignator[] $ticketDesignator
     */
    public function __construct(array $ticketDesignator = array())
    {
        $this
            ->setTicketDesignator($ticketDesignator);
    }
    /**
     * Get TicketDesignator value
     * @return \StructType\TicketDesignator[]|null
     */
    public function getTicketDesignator()
    {
        return $this->TicketDesignator;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDesignator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDesignator method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDesignatorForArrayConstraintsFromSetTicketDesignator(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDesignatorsTicketDesignatorItem) {
            // validation for constraint: itemType
            if (!$ticketDesignatorsTicketDesignatorItem instanceof \StructType\TicketDesignator) {
                $invalidValues[] = is_object($ticketDesignatorsTicketDesignatorItem) ? get_class($ticketDesignatorsTicketDesignatorItem) : sprintf('%s(%s)', gettype($ticketDesignatorsTicketDesignatorItem), var_export($ticketDesignatorsTicketDesignatorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDesignator property can only contain items of type \StructType\TicketDesignator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDesignator value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDesignator[] $ticketDesignator
     * @return \StructType\TicketDesignators
     */
    public function setTicketDesignator(array $ticketDesignator = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDesignatorArrayErrorMessage = self::validateTicketDesignatorForArrayConstraintsFromSetTicketDesignator($ticketDesignator))) {
            throw new \InvalidArgumentException($ticketDesignatorArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($ticketDesignator) && count($ticketDesignator) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($ticketDesignator)), __LINE__);
        }
        $this->TicketDesignator = $ticketDesignator;
        return $this;
    }
    /**
     * Add item to TicketDesignator value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDesignator $item
     * @return \StructType\TicketDesignators
     */
    public function addToTicketDesignator(\StructType\TicketDesignator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDesignator) {
            throw new \InvalidArgumentException(sprintf('The TicketDesignator property can only contain items of type \StructType\TicketDesignator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->TicketDesignator) && count($this->TicketDesignator) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->TicketDesignator)), __LINE__);
        }
        $this->TicketDesignator[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketDesignators
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
