<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDesignator StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the discount code and a flight reference applicable to the fare. | Ticket designation code and qualifier.
 * @subpackage Structs
 */
class TicketDesignator extends AbstractStructBase
{
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies a discount code applicable to the fare. | The applicable code as provided for in ATA SIPP Reso 110.16 or IATA Reso 728.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The TicketDesignatorQualifier
     * Meta information extracted from the WSDL
     * - documentation: Used to qualify the ticket designator.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorQualifier;
    /**
     * The FlightRefRPH
     * Meta information extracted from the WSDL
     * - documentation: Identifies the flight to which this ticket designator applies.
     * - use: optional
     * @var string
     */
    public $FlightRefRPH;
    /**
     * The TicketDesignatorExtension
     * Meta information extracted from the WSDL
     * - documentation: Specifies an extension that a carrier may apply to a ticket designator.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorExtension;
    /**
     * Constructor method for TicketDesignator
     * @uses TicketDesignator::setTicketDesignatorCode()
     * @uses TicketDesignator::setTicketDesignatorQualifier()
     * @uses TicketDesignator::setFlightRefRPH()
     * @uses TicketDesignator::setTicketDesignatorExtension()
     * @param string $ticketDesignatorCode
     * @param string $ticketDesignatorQualifier
     * @param string $flightRefRPH
     * @param string $ticketDesignatorExtension
     */
    public function __construct($ticketDesignatorCode = null, $ticketDesignatorQualifier = null, $flightRefRPH = null, $ticketDesignatorExtension = null)
    {
        $this
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setTicketDesignatorQualifier($ticketDesignatorQualifier)
            ->setFlightRefRPH($flightRefRPH)
            ->setTicketDesignatorExtension($ticketDesignatorExtension);
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\TicketDesignator
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get TicketDesignatorQualifier value
     * @return string|null
     */
    public function getTicketDesignatorQualifier()
    {
        return $this->TicketDesignatorQualifier;
    }
    /**
     * Set TicketDesignatorQualifier value
     * @param string $ticketDesignatorQualifier
     * @return \StructType\TicketDesignator
     */
    public function setTicketDesignatorQualifier($ticketDesignatorQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorQualifier) && !is_string($ticketDesignatorQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorQualifier, true), gettype($ticketDesignatorQualifier)), __LINE__);
        }
        $this->TicketDesignatorQualifier = $ticketDesignatorQualifier;
        return $this;
    }
    /**
     * Get FlightRefRPH value
     * @return string|null
     */
    public function getFlightRefRPH()
    {
        return $this->FlightRefRPH;
    }
    /**
     * Set FlightRefRPH value
     * @param string $flightRefRPH
     * @return \StructType\TicketDesignator
     */
    public function setFlightRefRPH($flightRefRPH = null)
    {
        // validation for constraint: string
        if (!is_null($flightRefRPH) && !is_string($flightRefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightRefRPH, true), gettype($flightRefRPH)), __LINE__);
        }
        $this->FlightRefRPH = $flightRefRPH;
        return $this;
    }
    /**
     * Get TicketDesignatorExtension value
     * @return string|null
     */
    public function getTicketDesignatorExtension()
    {
        return $this->TicketDesignatorExtension;
    }
    /**
     * Set TicketDesignatorExtension value
     * @param string $ticketDesignatorExtension
     * @return \StructType\TicketDesignator
     */
    public function setTicketDesignatorExtension($ticketDesignatorExtension = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorExtension) && !is_string($ticketDesignatorExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorExtension, true), gettype($ticketDesignatorExtension)), __LINE__);
        }
        $this->TicketDesignatorExtension = $ticketDesignatorExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketDesignator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
