<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TermsAndConditions StructType
 * Meta information extracted from the WSDL
 * - documentation: Terms and conditions that apply to the offer.
 * @subpackage Structs
 */
class TermsAndConditions extends AbstractStructBase
{
    /**
     * The VoluntaryChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VoluntaryChanges
     */
    public $VoluntaryChanges;
    /**
     * The VoluntaryRefunds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VoluntaryRefunds
     */
    public $VoluntaryRefunds;
    /**
     * The Other
     * Meta information extracted from the WSDL
     * - documentation: Other terms and conditions that apply to offer.
     * - minOccurs: 0
     * @var string
     */
    public $Other;
    /**
     * The RefundableInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the item(s) associated with the offer are refundable.
     * - use: optional
     * @var bool
     */
    public $RefundableInd;
    /**
     * The ReusableFundsInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the funds are reusable.
     * - use: optional
     * @var bool
     */
    public $ReusableFundsInd;
    /**
     * Constructor method for TermsAndConditions
     * @uses TermsAndConditions::setVoluntaryChanges()
     * @uses TermsAndConditions::setVoluntaryRefunds()
     * @uses TermsAndConditions::setOther()
     * @uses TermsAndConditions::setRefundableInd()
     * @uses TermsAndConditions::setReusableFundsInd()
     * @param \StructType\VoluntaryChanges $voluntaryChanges
     * @param \StructType\VoluntaryRefunds $voluntaryRefunds
     * @param string $other
     * @param bool $refundableInd
     * @param bool $reusableFundsInd
     */
    public function __construct(\StructType\VoluntaryChanges $voluntaryChanges = null, \StructType\VoluntaryRefunds $voluntaryRefunds = null, $other = null, $refundableInd = null, $reusableFundsInd = null)
    {
        $this
            ->setVoluntaryChanges($voluntaryChanges)
            ->setVoluntaryRefunds($voluntaryRefunds)
            ->setOther($other)
            ->setRefundableInd($refundableInd)
            ->setReusableFundsInd($reusableFundsInd);
    }
    /**
     * Get VoluntaryChanges value
     * @return \StructType\VoluntaryChanges|null
     */
    public function getVoluntaryChanges()
    {
        return $this->VoluntaryChanges;
    }
    /**
     * Set VoluntaryChanges value
     * @param \StructType\VoluntaryChanges $voluntaryChanges
     * @return \StructType\TermsAndConditions
     */
    public function setVoluntaryChanges(\StructType\VoluntaryChanges $voluntaryChanges = null)
    {
        $this->VoluntaryChanges = $voluntaryChanges;
        return $this;
    }
    /**
     * Get VoluntaryRefunds value
     * @return \StructType\VoluntaryRefunds|null
     */
    public function getVoluntaryRefunds()
    {
        return $this->VoluntaryRefunds;
    }
    /**
     * Set VoluntaryRefunds value
     * @param \StructType\VoluntaryRefunds $voluntaryRefunds
     * @return \StructType\TermsAndConditions
     */
    public function setVoluntaryRefunds(\StructType\VoluntaryRefunds $voluntaryRefunds = null)
    {
        $this->VoluntaryRefunds = $voluntaryRefunds;
        return $this;
    }
    /**
     * Get Other value
     * @return string|null
     */
    public function getOther()
    {
        return $this->Other;
    }
    /**
     * Set Other value
     * @param string $other
     * @return \StructType\TermsAndConditions
     */
    public function setOther($other = null)
    {
        // validation for constraint: string
        if (!is_null($other) && !is_string($other)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($other, true), gettype($other)), __LINE__);
        }
        $this->Other = $other;
        return $this;
    }
    /**
     * Get RefundableInd value
     * @return bool|null
     */
    public function getRefundableInd()
    {
        return $this->RefundableInd;
    }
    /**
     * Set RefundableInd value
     * @param bool $refundableInd
     * @return \StructType\TermsAndConditions
     */
    public function setRefundableInd($refundableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundableInd) && !is_bool($refundableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundableInd, true), gettype($refundableInd)), __LINE__);
        }
        $this->RefundableInd = $refundableInd;
        return $this;
    }
    /**
     * Get ReusableFundsInd value
     * @return bool|null
     */
    public function getReusableFundsInd()
    {
        return $this->ReusableFundsInd;
    }
    /**
     * Set ReusableFundsInd value
     * @param bool $reusableFundsInd
     * @return \StructType\TermsAndConditions
     */
    public function setReusableFundsInd($reusableFundsInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reusableFundsInd) && !is_bool($reusableFundsInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reusableFundsInd, true), gettype($reusableFundsInd)), __LINE__);
        }
        $this->ReusableFundsInd = $reusableFundsInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TermsAndConditions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
