<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TermAndCondition StructType
 * Meta information extracted from the WSDL
 * - documentation: Terms and conditions incuding fare rules.
 * @subpackage Structs
 */
class TermAndCondition extends AbstractStructBase
{
    /**
     * The FareRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FareRule
     */
    public $FareRule;
    /**
     * The EffectiveDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EffectiveDates
     */
    public $EffectiveDates;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Free text description for a a fare rule or terms and conditions.
     * - minOccurs: 0
     * @var mixed
     */
    public $Description;
    /**
     * Constructor method for TermAndCondition
     * @uses TermAndCondition::setFareRule()
     * @uses TermAndCondition::setEffectiveDates()
     * @uses TermAndCondition::setDescription()
     * @param \StructType\FareRule $fareRule
     * @param \StructType\EffectiveDates $effectiveDates
     * @param mixed $description
     */
    public function __construct(\StructType\FareRule $fareRule = null, \StructType\EffectiveDates $effectiveDates = null, $description = null)
    {
        $this
            ->setFareRule($fareRule)
            ->setEffectiveDates($effectiveDates)
            ->setDescription($description);
    }
    /**
     * Get FareRule value
     * @return \StructType\FareRule|null
     */
    public function getFareRule()
    {
        return $this->FareRule;
    }
    /**
     * Set FareRule value
     * @param \StructType\FareRule $fareRule
     * @return \StructType\TermAndCondition
     */
    public function setFareRule(\StructType\FareRule $fareRule = null)
    {
        $this->FareRule = $fareRule;
        return $this;
    }
    /**
     * Get EffectiveDates value
     * @return \StructType\EffectiveDates|null
     */
    public function getEffectiveDates()
    {
        return $this->EffectiveDates;
    }
    /**
     * Set EffectiveDates value
     * @param \StructType\EffectiveDates $effectiveDates
     * @return \StructType\TermAndCondition
     */
    public function setEffectiveDates(\StructType\EffectiveDates $effectiveDates = null)
    {
        $this->EffectiveDates = $effectiveDates;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param mixed $description
     * @return \StructType\TermAndCondition
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TermAndCondition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
