<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxExemption StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax exemption criteria.
 * @subpackage Structs
 */
class TaxExemption extends AbstractStructBase
{
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxCode[]
     */
    public $TaxCode;
    /**
     * The ExemptAllInd
     * Meta information extracted from the WSDL
     * - documentation: If true, exclude taxes from all priced offers.
     * - use: optional
     * @var bool
     */
    public $ExemptAllInd;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: If this code is entered, it overrides the TicketingCityCode. | ISO 3166 Alpha-3 Country Codes: http://en.wikipedia.org/wiki/ISO_3166-1_alpha-3 | The country code for tax exemption in ISO 3166 encoding.
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The ProvinceCode
     * Meta information extracted from the WSDL
     * - documentation: A province code for tax exemption.
     * - use: optional
     * @var string
     */
    public $ProvinceCode;
    /**
     * The GovernmentBody
     * Meta information extracted from the WSDL
     * - documentation: A government body that's tax exempt.
     * - use: optional
     * @var string
     */
    public $GovernmentBody;
    /**
     * Constructor method for TaxExemption
     * @uses TaxExemption::setTaxCode()
     * @uses TaxExemption::setExemptAllInd()
     * @uses TaxExemption::setCountryCode()
     * @uses TaxExemption::setProvinceCode()
     * @uses TaxExemption::setGovernmentBody()
     * @param \StructType\TaxCode[] $taxCode
     * @param bool $exemptAllInd
     * @param string $countryCode
     * @param string $provinceCode
     * @param string $governmentBody
     */
    public function __construct(array $taxCode = array(), $exemptAllInd = null, $countryCode = null, $provinceCode = null, $governmentBody = null)
    {
        $this
            ->setTaxCode($taxCode)
            ->setExemptAllInd($exemptAllInd)
            ->setCountryCode($countryCode)
            ->setProvinceCode($provinceCode)
            ->setGovernmentBody($governmentBody);
    }
    /**
     * Get TaxCode value
     * @return \StructType\TaxCode[]|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxCodeForArrayConstraintsFromSetTaxCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxExemptionTaxCodeItem) {
            // validation for constraint: itemType
            if (!$taxExemptionTaxCodeItem instanceof \StructType\TaxCode) {
                $invalidValues[] = is_object($taxExemptionTaxCodeItem) ? get_class($taxExemptionTaxCodeItem) : sprintf('%s(%s)', gettype($taxExemptionTaxCodeItem), var_export($taxExemptionTaxCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCode property can only contain items of type \StructType\TaxCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCode value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxCode[] $taxCode
     * @return \StructType\TaxExemption
     */
    public function setTaxCode(array $taxCode = array())
    {
        // validation for constraint: array
        if ('' !== ($taxCodeArrayErrorMessage = self::validateTaxCodeForArrayConstraintsFromSetTaxCode($taxCode))) {
            throw new \InvalidArgumentException($taxCodeArrayErrorMessage, __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Add item to TaxCode value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxCode $item
     * @return \StructType\TaxExemption
     */
    public function addToTaxCode(\StructType\TaxCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxCode) {
            throw new \InvalidArgumentException(sprintf('The TaxCode property can only contain items of type \StructType\TaxCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCode[] = $item;
        return $this;
    }
    /**
     * Get ExemptAllInd value
     * @return bool|null
     */
    public function getExemptAllInd()
    {
        return $this->ExemptAllInd;
    }
    /**
     * Set ExemptAllInd value
     * @param bool $exemptAllInd
     * @return \StructType\TaxExemption
     */
    public function setExemptAllInd($exemptAllInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($exemptAllInd) && !is_bool($exemptAllInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exemptAllInd, true), gettype($exemptAllInd)), __LINE__);
        }
        $this->ExemptAllInd = $exemptAllInd;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\TaxExemption
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get ProvinceCode value
     * @return string|null
     */
    public function getProvinceCode()
    {
        return $this->ProvinceCode;
    }
    /**
     * Set ProvinceCode value
     * @param string $provinceCode
     * @return \StructType\TaxExemption
     */
    public function setProvinceCode($provinceCode = null)
    {
        // validation for constraint: string
        if (!is_null($provinceCode) && !is_string($provinceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinceCode, true), gettype($provinceCode)), __LINE__);
        }
        $this->ProvinceCode = $provinceCode;
        return $this;
    }
    /**
     * Get GovernmentBody value
     * @return string|null
     */
    public function getGovernmentBody()
    {
        return $this->GovernmentBody;
    }
    /**
     * Set GovernmentBody value
     * @param string $governmentBody
     * @return \StructType\TaxExemption
     */
    public function setGovernmentBody($governmentBody = null)
    {
        // validation for constraint: string
        if (!is_null($governmentBody) && !is_string($governmentBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($governmentBody, true), gettype($governmentBody)), __LINE__);
        }
        $this->GovernmentBody = $governmentBody;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxExemption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
