<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Exemption tax code(s) and types.
 * - type: StringLength1to16
 * - use: optional
 * @subpackage Structs
 */
class TaxCode extends AbstractStructBase
{
    /**
     * The DesignatorCode
     * @var \StructType\DesignatorCode
     */
    public $DesignatorCode;
    /**
     * The TaxType
     * Meta information extracted from the WSDL
     * - documentation: Tax type(s) associated with the designator code.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TaxType;
    /**
     * Constructor method for TaxCode
     * @uses TaxCode::setDesignatorCode()
     * @uses TaxCode::setTaxType()
     * @param \StructType\DesignatorCode $designatorCode
     * @param string[] $taxType
     */
    public function __construct(\StructType\DesignatorCode $designatorCode = null, array $taxType = array())
    {
        $this
            ->setDesignatorCode($designatorCode)
            ->setTaxType($taxType);
    }
    /**
     * Get DesignatorCode value
     * @return \StructType\DesignatorCode|null
     */
    public function getDesignatorCode()
    {
        return $this->DesignatorCode;
    }
    /**
     * Set DesignatorCode value
     * @param \StructType\DesignatorCode $designatorCode
     * @return \StructType\TaxCode
     */
    public function setDesignatorCode(\StructType\DesignatorCode $designatorCode = null)
    {
        $this->DesignatorCode = $designatorCode;
        return $this;
    }
    /**
     * Get TaxType value
     * @return string[]|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTypeForArrayConstraintsFromSetTaxType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxCodeTaxTypeItem) {
            // validation for constraint: itemType
            if (!is_string($taxCodeTaxTypeItem)) {
                $invalidValues[] = is_object($taxCodeTaxTypeItem) ? get_class($taxCodeTaxTypeItem) : sprintf('%s(%s)', gettype($taxCodeTaxTypeItem), var_export($taxCodeTaxTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxType property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxType value
     * @throws \InvalidArgumentException
     * @param string[] $taxType
     * @return \StructType\TaxCode
     */
    public function setTaxType(array $taxType = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTypeArrayErrorMessage = self::validateTaxTypeForArrayConstraintsFromSetTaxType($taxType))) {
            throw new \InvalidArgumentException($taxTypeArrayErrorMessage, __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Add item to TaxType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TaxCode
     */
    public function addToTaxType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TaxType property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
