<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplements StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of supplements (e.g., meal plans or gala dinners).
 * @subpackage Structs
 */
class Supplements extends AbstractStructBase
{
    /**
     * The Supplement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Supplement[]
     */
    public $Supplement;
    /**
     * Constructor method for Supplements
     * @uses Supplements::setSupplement()
     * @param \StructType\Supplement[] $supplement
     */
    public function __construct(array $supplement = array())
    {
        $this
            ->setSupplement($supplement);
    }
    /**
     * Get Supplement value
     * @return \StructType\Supplement[]|null
     */
    public function getSupplement()
    {
        return $this->Supplement;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplementForArrayConstraintsFromSetSupplement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplementsSupplementItem) {
            // validation for constraint: itemType
            if (!$supplementsSupplementItem instanceof \StructType\Supplement) {
                $invalidValues[] = is_object($supplementsSupplementItem) ? get_class($supplementsSupplementItem) : sprintf('%s(%s)', gettype($supplementsSupplementItem), var_export($supplementsSupplementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplement property can only contain items of type \StructType\Supplement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplement value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplement[] $supplement
     * @return \StructType\Supplements
     */
    public function setSupplement(array $supplement = array())
    {
        // validation for constraint: array
        if ('' !== ($supplementArrayErrorMessage = self::validateSupplementForArrayConstraintsFromSetSupplement($supplement))) {
            throw new \InvalidArgumentException($supplementArrayErrorMessage, __LINE__);
        }
        $this->Supplement = $supplement;
        return $this;
    }
    /**
     * Add item to Supplement value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplement $item
     * @return \StructType\Supplements
     */
    public function addToSupplement(\StructType\Supplement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplement) {
            throw new \InvalidArgumentException(sprintf('The Supplement property can only contain items of type \StructType\Supplement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Supplements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
