<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubType StructType
 * Meta information extracted from the WSDL
 * - documentation: Cabin sub-type information. This is typically used to describe virtual marketing cabin information associated with the cabin.
 * @subpackage Structs
 */
class SubType extends AbstractStructBase
{
    /**
     * The SeatType
     * Meta information extracted from the WSDL
     * - documentation: A seat preference. Use a value from the OpenTravel Seat Type Preference (STP) code list or enter a string value known to your trading partners.
     * - use: optional
     * @var string
     */
    public $SeatType;
    /**
     * The ClassCode
     * Meta information extracted from the WSDL
     * - documentation: The cabin class. Use a value from the enumerated list or enter a string value that is known to your trading partners.
     * - use: optional
     * @var string
     */
    public $ClassCode;
    /**
     * Constructor method for SubType
     * @uses SubType::setSeatType()
     * @uses SubType::setClassCode()
     * @param string $seatType
     * @param string $classCode
     */
    public function __construct($seatType = null, $classCode = null)
    {
        $this
            ->setSeatType($seatType)
            ->setClassCode($classCode);
    }
    /**
     * Get SeatType value
     * @return string|null
     */
    public function getSeatType()
    {
        return $this->SeatType;
    }
    /**
     * Set SeatType value
     * @param string $seatType
     * @return \StructType\SubType
     */
    public function setSeatType($seatType = null)
    {
        // validation for constraint: string
        if (!is_null($seatType) && !is_string($seatType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatType, true), gettype($seatType)), __LINE__);
        }
        $this->SeatType = $seatType;
        return $this;
    }
    /**
     * Get ClassCode value
     * @return string|null
     */
    public function getClassCode()
    {
        return $this->ClassCode;
    }
    /**
     * Set ClassCode value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classCode
     * @return \StructType\SubType
     */
    public function setClassCode($classCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($classCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($classCode) ? implode(', ', $classCode) : var_export($classCode, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->ClassCode = $classCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
