<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubGroup StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline or ATPCO encoded sub-group code(s) that are associated with the group code.
 * @subpackage Structs
 */
class SubGroup extends AbstractStructBase
{
    /**
     * The CodeSource
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CodeSource;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The three character alphanumeric RFISC. | A unique product sub-group code that may be airline defined or a RFISC (reason for issuance sub-code.)
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The AdditionalCode
     * Meta information extracted from the WSDL
     * - documentation: The three character alphanumeric RFISC. | An additional code that further defines the sub-group.
     * - use: optional
     * @var string
     */
    public $AdditionalCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description of the sub-group code.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for this product sub-group that is referenced elsewhere in this schema.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ResultsAction
     * Meta information extracted from the WSDL
     * - documentation: An indicator if the product group is required and/or should be included or excluded from the offer results.
     * - use: optional
     * @var string
     */
    public $ResultsAction;
    /**
     * Constructor method for SubGroup
     * @uses SubGroup::setCodeSource()
     * @uses SubGroup::setCode()
     * @uses SubGroup::setAdditionalCode()
     * @uses SubGroup::setDescription()
     * @uses SubGroup::setRPH()
     * @uses SubGroup::setResultsAction()
     * @param string $codeSource
     * @param string $code
     * @param string $additionalCode
     * @param string $description
     * @param string $rPH
     * @param string $resultsAction
     */
    public function __construct($codeSource = null, $code = null, $additionalCode = null, $description = null, $rPH = null, $resultsAction = null)
    {
        $this
            ->setCodeSource($codeSource)
            ->setCode($code)
            ->setAdditionalCode($additionalCode)
            ->setDescription($description)
            ->setRPH($rPH)
            ->setResultsAction($resultsAction);
    }
    /**
     * Get CodeSource value
     * @return string|null
     */
    public function getCodeSource()
    {
        return $this->CodeSource;
    }
    /**
     * Set CodeSource value
     * @param string $codeSource
     * @return \StructType\SubGroup
     */
    public function setCodeSource($codeSource = null)
    {
        // validation for constraint: string
        if (!is_null($codeSource) && !is_string($codeSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeSource, true), gettype($codeSource)), __LINE__);
        }
        $this->CodeSource = $codeSource;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SubGroup
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get AdditionalCode value
     * @return string|null
     */
    public function getAdditionalCode()
    {
        return $this->AdditionalCode;
    }
    /**
     * Set AdditionalCode value
     * @param string $additionalCode
     * @return \StructType\SubGroup
     */
    public function setAdditionalCode($additionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($additionalCode) && !is_string($additionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalCode, true), gettype($additionalCode)), __LINE__);
        }
        $this->AdditionalCode = $additionalCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SubGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\SubGroup
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ResultsAction value
     * @return string|null
     */
    public function getResultsAction()
    {
        return $this->ResultsAction;
    }
    /**
     * Set ResultsAction value
     * @uses \EnumType\IncludeExcludeType::valueIsValid()
     * @uses \EnumType\IncludeExcludeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultsAction
     * @return \StructType\SubGroup
     */
    public function setResultsAction($resultsAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IncludeExcludeType::valueIsValid($resultsAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IncludeExcludeType', is_array($resultsAction) ? implode(', ', $resultsAction) : var_export($resultsAction, true), implode(', ', \EnumType\IncludeExcludeType::getValidValues())), __LINE__);
        }
        $this->ResultsAction = $resultsAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
