<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StayRestrictionsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining Min and Max Stay Restrictions.
 * @subpackage Structs
 */
class StayRestrictionsType extends AbstractStructBase
{
    /**
     * The MinimumStay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MinimumStay
     */
    public $MinimumStay;
    /**
     * The MaximumStay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MaximumStay
     */
    public $MaximumStay;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The StayRestrictionsInd
     * Meta information extracted from the WSDL
     * - documentation: True indicates that Stay Restrictions exist.
     * - use: optional
     * @var bool
     */
    public $StayRestrictionsInd;
    /**
     * Constructor method for StayRestrictionsType
     * @uses StayRestrictionsType::setMinimumStay()
     * @uses StayRestrictionsType::setMaximumStay()
     * @uses StayRestrictionsType::setTPA_Extensions()
     * @uses StayRestrictionsType::setStayRestrictionsInd()
     * @param \StructType\MinimumStay $minimumStay
     * @param \StructType\MaximumStay $maximumStay
     * @param mixed $tPA_Extensions
     * @param bool $stayRestrictionsInd
     */
    public function __construct(\StructType\MinimumStay $minimumStay = null, \StructType\MaximumStay $maximumStay = null, $tPA_Extensions = null, $stayRestrictionsInd = null)
    {
        $this
            ->setMinimumStay($minimumStay)
            ->setMaximumStay($maximumStay)
            ->setTPA_Extensions($tPA_Extensions)
            ->setStayRestrictionsInd($stayRestrictionsInd);
    }
    /**
     * Get MinimumStay value
     * @return \StructType\MinimumStay|null
     */
    public function getMinimumStay()
    {
        return $this->MinimumStay;
    }
    /**
     * Set MinimumStay value
     * @param \StructType\MinimumStay $minimumStay
     * @return \StructType\StayRestrictionsType
     */
    public function setMinimumStay(\StructType\MinimumStay $minimumStay = null)
    {
        $this->MinimumStay = $minimumStay;
        return $this;
    }
    /**
     * Get MaximumStay value
     * @return \StructType\MaximumStay|null
     */
    public function getMaximumStay()
    {
        return $this->MaximumStay;
    }
    /**
     * Set MaximumStay value
     * @param \StructType\MaximumStay $maximumStay
     * @return \StructType\StayRestrictionsType
     */
    public function setMaximumStay(\StructType\MaximumStay $maximumStay = null)
    {
        $this->MaximumStay = $maximumStay;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\StayRestrictionsType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get StayRestrictionsInd value
     * @return bool|null
     */
    public function getStayRestrictionsInd()
    {
        return $this->StayRestrictionsInd;
    }
    /**
     * Set StayRestrictionsInd value
     * @param bool $stayRestrictionsInd
     * @return \StructType\StayRestrictionsType
     */
    public function setStayRestrictionsInd($stayRestrictionsInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($stayRestrictionsInd) && !is_bool($stayRestrictionsInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stayRestrictionsInd, true), gettype($stayRestrictionsInd)), __LINE__);
        }
        $this->StayRestrictionsInd = $stayRestrictionsInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StayRestrictionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
