<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StayInfosType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of StayInfo objects
 * @subpackage Structs
 */
class StayInfosType extends AbstractStructBase
{
    /**
     * The StayInfo
     * Meta information extracted from the WSDL
     * - documentation: Provides details of a guest's stay.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $StayInfo;
    /**
     * Constructor method for StayInfosType
     * @uses StayInfosType::setStayInfo()
     * @param mixed[] $stayInfo
     */
    public function __construct(array $stayInfo = array())
    {
        $this
            ->setStayInfo($stayInfo);
    }
    /**
     * Get StayInfo value
     * @return mixed[]|null
     */
    public function getStayInfo()
    {
        return $this->StayInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setStayInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStayInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStayInfoForArrayConstraintsFromSetStayInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stayInfosTypeStayInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($stayInfosTypeStayInfoItem) ? get_class($stayInfosTypeStayInfoItem) : sprintf('%s(%s)', gettype($stayInfosTypeStayInfoItem), var_export($stayInfosTypeStayInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StayInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StayInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $stayInfo
     * @return \StructType\StayInfosType
     */
    public function setStayInfo(array $stayInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($stayInfoArrayErrorMessage = self::validateStayInfoForArrayConstraintsFromSetStayInfo($stayInfo))) {
            throw new \InvalidArgumentException($stayInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($stayInfo) && count($stayInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($stayInfo)), __LINE__);
        }
        $this->StayInfo = $stayInfo;
        return $this;
    }
    /**
     * Add item to StayInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\StayInfosType
     */
    public function addToStayInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The StayInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->StayInfo) && count($this->StayInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->StayInfo)), __LINE__);
        }
        $this->StayInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StayInfosType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
